/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.util;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.cmd.RemoveFileCommand;
import oracle.ide.cmd.RenameMessage;
import oracle.ide.controller.Command;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.model.Workspace;
import oracle.javatools.util.Log;
import oracle.jdeveloper.vcs.spi.VCSFileEventSender;
import oracle.jdeveloper.vcs.util.VCSContextUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;

public final class VCSNodeCommands {
    private VCSNodeCommands() {
    }

    public static final Command createQuietCloseNodeCommand(Context context) {
        QuietCloseNodeCommand command = new QuietCloseNodeCommand();
        command.setContext(context);
        return command;
    }

    public static final Command createCloseNodeOnlyCommand(Context context) {
        QuietCloseNodeCommand command = new QuietCloseNodeCommand(1);
        command.setContext(context);
        return command;
    }

    public static final Command createRemoveNodeOnlyCommand(Context context) {
        QuietCloseNodeCommand command = new QuietCloseNodeCommand(2);
        command.setContext(context);
        return command;
    }

    public static final Command createMoveNodeCommand(Context context, URL destinationUrl) {
        MoveNodeCommand command = new MoveNodeCommand();
        command.setContext(context);
        command.setData(destinationUrl);
        return command;
    }

    private static class MoveNodeCommand
    extends Command {
        private static final int MOVE_NODE_CMD_ID = Ide.findOrCreateCmdID((String)new Object(){}.getClass().getName());

        public MoveNodeCommand() {
            super(MOVE_NODE_CMD_ID);
        }

        public int doit() throws Exception {
            Locatable[] selection = VCSContextUtils.getContextLocatables(this.getContext());
            if (selection.length <= 0) {
                return -1;
            }
            MoveNodeCommand.move((Node)selection[0], (URL)this.getData());
            return 0;
        }

        public static final void move(Node node, URL destinationUrl) throws Exception {
            Collection<Context> contexts = MoveNodeCommand.createNodeContexts(node);
            for (Context context : contexts) {
                RenameMessage.firePreChildRenamed((Subject)context.getProject(), (Context)context);
            }
            URL source = node.getURL();
            node.setURL(destinationUrl);
            for (Context context : contexts) {
                RenameMessage.fireObjectRenamed((Subject)node, (URL)source, (Context)context);
                RenameMessage.fireChildRenamed((Subject)context.getProject(), (URL)source, (Node)node, (Context)context);
                context.getProject().markDirty(true);
            }
        }

        private static final Collection<Context> createNodeContexts(Node node) {
            ArrayList<Context> contexts = new ArrayList<Context>();
            Iterator itr = NodeFactory.getCachedNodes();
            while (itr.hasNext()) {
                Project project;
                Object o = itr.next();
                if (!(o instanceof Project) || !(project = (Project)o).containsChild((Element)node)) continue;
                Context context = Context.newIdeContext((Node)node);
                context.setProject(project);
                contexts.add(context);
            }
            return contexts;
        }
    }

    private static class QuietCloseNodeCommand
    extends RemoveFileCommand {
        private static final int FLAG_CLOSE = 1;
        private static final int FLAG_REMOVE = 2;
        private final int _flags;
        private static final Log LOG = new Log("vcs");

        private QuietCloseNodeCommand() {
            this(3);
        }

        private QuietCloseNodeCommand(int flags) {
            this._flags = flags;
        }

        public int doit() {
            Locatable[] selection = VCSContextUtils.getContextLocatables(this.getContext());
            LinkedHashMap<Folder, List<Object>> nodeMap = new LinkedHashMap<Folder, List<Object>>();
            for (int i = 0; i < selection.length; ++i) {
                if (!(selection[i] instanceof Element) || !Ide.getWorkspaces().containsChild((Element)selection[i])) continue;
                this.addRemovalToNodeMap(nodeMap, (Folder)Ide.getWorkspaces(), selection[i]);
            }
            Workspace[] workspaces = VCSModelUtils.findCachedWorkspaces();
            for (int j = 0; j < workspaces.length; ++j) {
                for (int i = 0; i < selection.length; ++i) {
                    if (!(selection[i] instanceof Element) || !workspaces[j].containsChild((Element)selection[i])) continue;
                    this.addRemovalToNodeMap(nodeMap, (Folder)workspaces[j], selection[i]);
                }
            }
            Project[] projects = VCSModelUtils.findCachedProjects();
            for (int j = 0; j < projects.length; ++j) {
                for (int i = 0; i < selection.length; ++i) {
                    Folder owner;
                    if (!(selection[i] instanceof Element) || (owner = projects[j].findOwner((Element)selection[i])) == null) continue;
                    this.addRemovalToNodeMap(nodeMap, owner, selection[i]);
                }
            }
            LOG.trace("VCS: Dumping preparatory Node map prior to removals...");
            LOG.trace("" + nodeMap);
            for (Map.Entry<Folder, List<Object>> entry : nodeMap.entrySet()) {
                if ((this._flags & 1) > 0) {
                    UpdateMessage update = this.createUpdateMessage();
                    class CloseNodeCommandImpl
                    extends CloseNodeCommand {
                        public CloseNodeCommandImpl(UpdateMessage messageTemplate) {
                            super(messageTemplate);
                        }

                        public int checkSave(List dirtyNodes, boolean canCancel) {
                            return 0;
                        }
                    }
                    CloseNodeCommandImpl clsCmd = new CloseNodeCommandImpl(update);
                    clsCmd.setContext(this.getContext());
                    clsCmd.setNeedConfirm(this.isNeedConfirmClose());
                    int status = clsCmd.close(entry.getValue(), false, false);
                    if (status != 0) {
                        // empty if block
                    }
                }
                if ((this._flags & 2) > 0 && super.remove(entry.getValue(), entry.getKey(), false) == 0) continue;
            }
            if ((this._flags & 2) > 0) {
                for (int i = 0; i < selection.length; ++i) {
                    if (selection[i].getURL() == null) continue;
                    NodeFactory.uncache((URL)selection[i].getURL());
                }
                VCSFileEventSender.fireFileStructureChanged(VCSModelUtils.convertNodesToURLs(selection));
            }
            return 0;
        }

        private void addRemovalToNodeMap(Map<Folder, List<Object>> nodeMap, Folder owner, Object o) {
            List<Object> c = nodeMap.get(owner);
            if (c == null) {
                c = new ArrayList<Object>();
                nodeMap.put(owner, c);
            }
            c.add(o);
        }

        protected boolean isNeedConfirmClose() {
            return false;
        }
    }
}

