/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.net.URL;
import java.util.EventObject;
import oracle.ide.net.URLFilter;

public final class VCSURLBasedCacheEvent
extends EventObject {
    private final URL[] _urls;
    private final Object[] _values;
    private final URLFilter _filter;
    private final boolean _invalidate;
    private final URL _oldUrl;
    private final URL _newUrl;

    VCSURLBasedCacheEvent(Object source, URL[] urls, Object[] values) {
        super(source);
        this._urls = urls;
        this._values = values;
        this._filter = null;
        this._invalidate = false;
        this._oldUrl = null;
        this._newUrl = null;
    }

    VCSURLBasedCacheEvent(Object source, URL[] urls, URLFilter filter, boolean invalidate) {
        super(source);
        this._urls = urls;
        this._values = null;
        this._filter = filter;
        this._invalidate = invalidate;
        this._oldUrl = null;
        this._newUrl = null;
    }

    VCSURLBasedCacheEvent(Object source, URL oldUrl, URL newUrl, Object value) {
        super(source);
        this._urls = null;
        this._values = new Object[]{value};
        this._filter = null;
        this._invalidate = false;
        this._oldUrl = oldUrl;
        this._newUrl = newUrl;
    }

    public final URL[] getURLs() {
        return this._urls;
    }

    public final Object[] getValues() {
        return this._values;
    }

    public final URLFilter getFilter() {
        return this._filter;
    }

    public final boolean isInvalidate() {
        return this._invalidate;
    }

    public final URL getOldURL() {
        return this._oldUrl;
    }

    public final URL getNewURL() {
        return this._newUrl;
    }

    public final Object getValue() {
        return this._values != null && this._values.length > 0 ? this._values[0] : null;
    }
}

