/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import oracle.ide.feedback.FeedbackManager;
import oracle.javatools.util.Executors;

public class VCSThreadPool {
    private final ExecutorService _executor;
    private final Map<Runnable, Future> _futures = Collections.synchronizedMap(new HashMap());

    public VCSThreadPool(int max, String namePrefix) {
        this._executor = new ThreadPoolExecutor(0, max, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Executors.namedThreadFactory((String)namePrefix));
    }

    public void destroy() {
        this._executor.shutdown();
    }

    public void doTask(final Runnable task) {
        this._futures.put(task, this._executor.submit(new Runnable(){

            @Override
            public final void run() {
                task.run();
                VCSThreadPool.this._futures.remove(task);
            }
        }));
    }

    public void join(Runnable task) throws InterruptedException {
        Future future = this._futures.get(task);
        if (future == null) {
            return;
        }
        try {
            future.get();
        }
        catch (ExecutionException ee) {
            FeedbackManager.reportException((Throwable)ee);
        }
    }
}

