/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.historygraph;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.LineMetrics;
import java.text.DateFormat;
import java.util.Date;

class TimeDrawNode {
    private Date _commitDate;
    private String _displayLabel;
    private int _x;
    private int _y;

    TimeDrawNode(Long commit, int x, int y) {
        this._x = x;
        this._y = y;
        this._commitDate = new Date(commit);
    }

    int getX() {
        return this._x;
    }

    int getY() {
        return this._y;
    }

    void paint(Graphics2D gd) {
        Font font = gd.getFont();
        LineMetrics metric = font.getLineMetrics(this.getValue(), gd.getFontRenderContext());
        gd.drawString(this.getValue(), (float)this._x, (float)this._y + metric.getHeight());
    }

    private String getValue() {
        if (this._displayLabel == null) {
            this._displayLabel = DateFormat.getDateInstance().format(this._commitDate);
        }
        return this._displayLabel;
    }

    public String toString() {
        return this.getValue();
    }
}

