/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.historygraph;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import oracle.jdeveloper.vcs.historygraph.GraphNode;
import oracle.jdeveloper.vcs.res.Bundle;

class DrawNode {
    private Rectangle _rect;
    private GraphNode _node;
    private int _column;
    private boolean _highlight;
    private Color _color;
    private Color _selectColor;
    private boolean _selected;

    DrawNode(int x, int y, GraphNode stNode, int column) {
        this._rect = new Rectangle(x, y, 10, 10);
        this._node = stNode;
        this._column = column;
        this._highlight = false;
        this._selected = false;
        this._selectColor = new Color(255, 214, 66);
    }

    public boolean equals(Object o) {
        if (o instanceof DrawNode) {
            return this._rect.equals(((DrawNode)o)._rect);
        }
        return false;
    }

    Rectangle getRectangle() {
        return this._rect;
    }

    int getX() {
        return this._rect.x;
    }

    int getY() {
        return this._rect.y;
    }

    int getWidth() {
        return this._rect.width;
    }

    int getHeight() {
        return this._rect.height;
    }

    int getColumn() {
        return this._column;
    }

    void paint(Graphics2D gd) {
        if (this._highlight) {
            gd.setColor(Color.red);
        } else if (this._selected) {
            gd.setColor(this._selectColor);
        } else {
            gd.setColor(this._color);
        }
        gd.fillOval(this._rect.x, this._rect.y, this._rect.width, this._rect.height);
        if (this._node.isHead()) {
            String label = Bundle.get("COMMIT_HISTORY_HEAD");
            Font font = gd.getFont();
            FontMetrics metric = gd.getFontMetrics(font);
            gd.setColor(Color.black);
            gd.drawString(label, this._rect.x - metric.stringWidth(label), this._rect.y + metric.getHeight());
        }
    }

    Point getCentre() {
        return new Point(this._rect.x + this._rect.width / 2, this._rect.y + this._rect.height / 2);
    }

    boolean highLight(Point point) {
        if (this._rect.contains(point)) {
            this._highlight = true;
            return true;
        }
        if (this._highlight) {
            this._highlight = false;
            return true;
        }
        return false;
    }

    boolean isHighLight() {
        return this._highlight;
    }

    void clearHighLight() {
        this._highlight = false;
    }

    void setColor(Color color) {
        this._color = color;
    }

    Color getColor() {
        return this._color;
    }

    boolean contains(Point p) {
        return this._rect.contains(p);
    }

    GraphNode getUserObject() {
        return this._node;
    }

    void setSelected(boolean select) {
        this._selected = select;
    }

    boolean isSelected() {
        return this._selected;
    }
}

