/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.ide.extension.ExtensionRegistry;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.docking.DockableFactory;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.layout.ViewId;
import oracle.javatools.annotations.NotNull;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListWindow;
import oracle.jdeveloper.vcs.spi.VCSDockableViewRegistry;
import oracle.jdevimpl.vcs.ClassUtil;

public class ChangeListDockableFactory
implements DockableFactory {
    private final ChangeList _changeList;
    private ChangeListWindow _changeListWindow;
    private final String _windowID;
    private final String _windowClassName;
    private final String _vcsId;

    @Deprecated
    public ChangeListDockableFactory(String windowID, ChangeList changeList) {
        this(windowID, changeList, null, null);
    }

    public ChangeListDockableFactory(String windowID, String className, @NotNull String vcsId) {
        this(windowID, null, className, vcsId);
    }

    public ChangeListDockableFactory(String windowID, ChangeList changeList, String className, String vcsId) {
        this._windowID = ViewId.validate((String)windowID);
        this._changeList = changeList;
        this._windowClassName = className;
        this._vcsId = vcsId;
        if (this._windowClassName != null && this._vcsId == null) {
            throw new IllegalArgumentException("VCS extension ID must be non-null");
        }
        DockStation.getDockStation().unregisterDockableFactory(this._windowID);
        DockStation.getDockStation().registerDockableFactory(this._windowID, (DockableFactory)this);
    }

    public Dockable getDockable(ViewId viewId) {
        return this.getChangeListWindow();
    }

    public void install() {
    }

    private ChangeListWindow getChangeListWindow() {
        if (this._changeListWindow == null) {
            this._changeListWindow = this.createChangeListWindow(this._changeList);
            VCSDockableViewRegistry.registerDockableView(this._windowID, 2);
        }
        if (this._changeListWindow != null) {
            this._changeListWindow.setSystemId(this._vcsId);
        }
        return this._changeListWindow;
    }

    protected ChangeListWindow createChangeListWindow(ChangeList changeList) {
        if (this._windowClassName == null) {
            return new ChangeListWindow(changeList, this._windowID);
        }
        try {
            ClassLoader loader = ExtensionRegistry.getExtensionRegistry().getClassLoader(this._vcsId);
            Class<?> c = Class.forName(this._windowClassName, true, loader);
            if (this._changeList != null) {
                Constructor<?> constructor = c.getConstructor(ChangeList.class, String.class);
                return (ChangeListWindow)((Object)ClassUtil.newInstance(constructor, this._changeList, this._windowID));
            }
            Constructor<?> constructor = c.getConstructor(String.class);
            return (ChangeListWindow)((Object)ClassUtil.newInstance(constructor, this.getWindowId()));
        }
        catch (InstantiationException e) {
            FeedbackManager.reportException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            FeedbackManager.reportException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            FeedbackManager.reportException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            FeedbackManager.reportException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            FeedbackManager.reportException((Throwable)e);
        }
        return null;
    }

    protected String getWindowClassName() {
        return this._windowClassName;
    }

    protected String getWindowId() {
        return this._windowID;
    }
}

