/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.changelist;

import java.awt.EventQueue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TimerTask;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.ide.view.View;
import oracle.jdeveloper.vcs.changelist.AsynchronousChangeList;
import oracle.jdeveloper.vcs.changelist.AsynchronousStatusCache;
import oracle.jdeveloper.vcs.changelist.ChangeList;
import oracle.jdeveloper.vcs.changelist.ChangeListEvent;
import oracle.jdeveloper.vcs.changelist.ChangeListProjectContent;
import oracle.jdeveloper.vcs.spi.VCSHashURL;
import oracle.jdeveloper.vcs.spi.VCSThreadPool;
import oracle.jdeveloper.vcs.util.VCSFileSystemUtils;
import oracle.jdeveloper.vcs.util.VCSModelUtils;
import oracle.jdeveloper.vcs.util.VCSURLFilters;

public abstract class AsynchronousStatusTask
extends TimerTask {
    private final AsynchronousStatusCache _changeListStatusCache;
    private final AsynchronousChangeList.EventQueueImpl _changeListEventQueue;
    private final ChangeList _changeList;
    private final VCSThreadPool _threadPool;
    private boolean _cancelled;

    protected AsynchronousStatusTask(ChangeList changeList, VCSThreadPool threadPool) {
        this._changeListStatusCache = (AsynchronousStatusCache)changeList.getStatusCache();
        this._changeListEventQueue = (AsynchronousChangeList.EventQueueImpl)changeList.getEventQueue();
        this._changeList = changeList;
        this._threadPool = threadPool;
    }

    @Override
    public boolean cancel() {
        this._cancelled = true;
        return super.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        if (!this.isClientReady()) {
            return;
        }
        if (this._changeListEventQueue.isTaskInProgress() || this._changeList.isBusy()) {
            return;
        }
        this.setChangeListBusy(true);
        LinkedHashSet<VCSHashURL> directoriesToQuery = new LinkedHashSet<VCSHashURL>();
        Project[] projects = VCSModelUtils.findCachedProjects();
        for (int i = 0; i < projects.length; ++i) {
            ArrayList<URL> directoryUrls = null;
            try {
                directoryUrls = new ArrayList<URL>(Arrays.asList(new ChangeListProjectContent(projects[i]).getBaseDirectoryURLs()));
            }
            catch (Exception e) {
                Assert.printStackTrace((Throwable)e);
                this.setChangeListBusy(false);
                return;
            }
            Iterator itr = directoryUrls.iterator();
            while (itr.hasNext()) {
                URL directoryUrl = (URL)itr.next();
                if (URLFileSystem.isDirectory((URL)directoryUrl) && this.isControlled(directoryUrl)) continue;
                itr.remove();
            }
            directoriesToQuery.addAll(VCSHashURL.convertFromURLs(Arrays.asList(VCSFileSystemUtils.coalesceURLs(directoryUrls.toArray(new URL[0])))));
        }
        try {
            if (this.canExit()) {
                return;
            }
            HashMap<VCSHashURL, Object> statusCacheMap = new HashMap<VCSHashURL, Object>();
            this.populateStatusCacheMap(statusCacheMap, directoriesToQuery);
            if (this.canExit()) {
                return;
            }
            LinkedHashSet<VCSHashURL> urls = new LinkedHashSet<VCSHashURL>();
            urls.addAll(VCSHashURL.convertFromURLs(Arrays.asList(this._changeListStatusCache.searchValues(VCSURLFilters.createNullFilter()))));
            urls.addAll(statusCacheMap.keySet());
            this._changeListStatusCache.setInternalCache(statusCacheMap);
            if (this.canExit()) {
                return;
            }
            ChangeListEvent cle = new ChangeListEvent(0);
            cle.setURLs(VCSHashURL.convertToURLs(urls).toArray(new URL[0]));
            cle.setUpdate(true);
            this._changeListEventQueue.enqueue(cle);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DockStation dockStation = DockStation.getDockStation();
                    Dockable dockable = dockStation.getDockable(new ViewId(AsynchronousStatusTask.this.getViewId()));
                    if (dockable instanceof View) {
                        ((View)dockable).updateVisibleActions();
                    }
                }
            });
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
        finally {
            this.setChangeListBusy(false);
        }
    }

    protected boolean isClientReady() {
        return true;
    }

    protected abstract void populateStatusCacheMap(Map<VCSHashURL, Object> var1, Collection<VCSHashURL> var2) throws Exception;

    protected abstract boolean isControlled(URL var1);

    protected abstract String getViewId();

    protected abstract boolean isChangeListVisible();

    protected VCSThreadPool getThreadPool() {
        return this._threadPool;
    }

    private void setChangeListBusy(final boolean isBusy) {
        ChangeListEvent cle = new ChangeListEvent(2);
        cle.setRunnable(new Runnable(){

            @Override
            public void run() {
                AsynchronousStatusTask.this._changeListEventQueue.setChangeListBusyImpl(isBusy);
            }
        });
        this._changeListEventQueue.enqueue(cle);
        this._changeListEventQueue.setTaskInProgress(isBusy);
    }

    protected boolean canExit() {
        return !this.isChangeListVisible() || !this._changeListEventQueue.isAlive() || this._cancelled;
    }
}

