/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.vcs.cache;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.javatools.util.Maps;

public class URICache {
    private static final int CACHE_SIZE = 5000;
    private static final Map<String, URI> _cache = new Maps.CacheMap(5000, Maps.CacheMap.NOT_CANONICAL);
    private static final Pattern URI_PATTERN = Pattern.compile("((.*?):)?(.*?)(#(.*+))?");

    private URICache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final URI get(URL url) {
        String externalForm = url.toExternalForm();
        Map<String, URI> map = _cache;
        synchronized (map) {
            URI uri = _cache.get(externalForm);
            if (uri == null) {
                uri = URICache.toURI(externalForm);
                _cache.put(externalForm, uri);
            }
            return uri;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final URI[] get(URL[] urls) {
        URI[] uris = new URI[urls.length];
        Map<String, URI> map = _cache;
        synchronized (map) {
            for (int i = 0; i < urls.length; ++i) {
                uris[i] = URICache.get(urls[i]);
            }
        }
        return uris;
    }

    private static final URI toURI(String externalForm) {
        try {
            return new URI(externalForm);
        }
        catch (URISyntaxException uRISyntaxException) {
            try {
                Matcher matcher = URI_PATTERN.matcher(externalForm);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException();
                }
                return new URI(matcher.group(2), matcher.group(3), matcher.group(5));
            }
            catch (URISyntaxException se) {
                throw new IllegalStateException();
            }
        }
    }

    public static final void clear() {
        _cache.clear();
    }

    public static final void main(String[] argv) {
        try {
            HashSet<URI> uris = new HashSet<URI>();
            URICache cache = new URICache();
            uris.add(URICache.get(new URL("file://username:password@example.com:8042/over/there/index%201.dtb;type=animal")));
            uris.add(URICache.get(new URL("file://username:password@example.com:8042/over/there/index%201.dtb;type=animal?name=ferret")));
            uris.add(URICache.get(new URL("file://username:password@example.com:8042/over/there/index%201.dtb;type=animal#nos")));
            uris.add(URICache.get(new URL("file://username:password@example.com:8042/over/there/index%201.dtb;type=animal?name=ferret#nos")));
            uris.add(URICache.get(new URL("file://username:password@example.com:8042/over/there/index 1.dtb;type=animal")));
            uris.add(URICache.get(new URL("file://username:password@example.com:8042/over/there/index 1.dtb;type=animal?name=ferret")));
            uris.add(URICache.get(new URL("file://username:password@example.com:8042/over/there/index 1.dtb;type=animal#nos")));
            uris.add(URICache.get(new URL("file://username:password@example.com:8042/over/there/index 1.dtb;type=animal?name=ferret#nos")));
            for (URI uri : uris) {
                System.out.println(uri);
            }
        }
        catch (MalformedURLException murle) {
            murle.printStackTrace();
        }
    }
}

