/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser.osx;

import java.io.File;
import java.util.logging.Logger;
import oracle.ide.Ide;
import oracle.javatools.util.PlatformUtils;

public class LaunchService {
    private static final String LIB_NAME = "LaunchService";
    private static final String LIB_DIR = "jdev/extensions/oracle.webbrowser.osx/";
    private boolean isLoaded = false;
    private boolean isError = false;
    private static final Logger _LOGGER = Logger.getLogger(LaunchService.class.getName());
    private static final LaunchService INSTANCE = new LaunchService();

    private LaunchService() {
        this.init();
    }

    public static LaunchService getInstance() {
        return INSTANCE;
    }

    private void init() {
        if (!this.isLoaded && !this.isError) {
            if (LaunchService.shouldTryLoading()) {
                try {
                    String libFilePath = Ide.getOracleHomeDirectory() + LIB_DIR + System.mapLibraryName(LIB_NAME);
                    File f = new File(libFilePath);
                    if (!f.exists()) {
                        this.isError = true;
                        _LOGGER.warning("Skip loading LaunchService library (file not found: " + libFilePath + ").");
                        return;
                    }
                    System.load(libFilePath);
                    this.isLoaded = true;
                }
                catch (Exception e) {
                    this.isError = true;
                    _LOGGER.warning("Skip loading LaunchService library (" + e + ").");
                }
                catch (Error e) {
                    this.isError = true;
                    _LOGGER.warning("Skip loading LaunchService library (" + e + ").");
                }
            } else {
                this.isError = true;
            }
        }
    }

    private static boolean shouldTryLoading() {
        String osName = PlatformUtils.osName();
        if (osName == null) {
            return true;
        }
        if (!PlatformUtils.isMac()) {
            return false;
        }
        String v = PlatformUtils.osVersion();
        String[] versionDigits = v.split("\\.");
        try {
            if (versionDigits.length == 1) {
                return Integer.parseInt(versionDigits[0]) > 10;
            }
            if (versionDigits.length > 1) {
                return Integer.parseInt(versionDigits[0]) >= 10 && Integer.parseInt(versionDigits[1]) >= 4;
            }
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public native String[] getAllHandlersForURLScheme(String var1);

    public native String getDefaultHandlerForURLScheme(String var1);

    public native int setDefaultHandlerForURLScheme(String var1, String var2);

    public native String getApplicationURL(String var1);
}

