/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.net.ProxySelector;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.config.IdeSettings;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.webbrowser.IdeProxySelector;
import oracle.ideimpl.webbrowser.SystemProxySettings;
import oracle.javatools.util.Copyable;

final class ProxyAddin
implements Addin {
    private static final Logger LOG = Logger.getLogger(ProxyAddin.class.getName());

    ProxyAddin() {
    }

    public void initialize() {
        ProxyOptions proxyOptions = ProxyOptions.getProxyOptions();
        String DISABLE_IDE_PROXY_SELECTOR = "jdeveloper.disable.ide.proxy.selector";
        if (!"true".equals(System.getProperty(DISABLE_IDE_PROXY_SELECTOR))) {
            ProxyAddin.installIdeProxySelector();
        }
        IdeSettings ideSettings = Ide.getSettings();
        ideSettings.putLegacyData("proxy-options", (Copyable)proxyOptions);
        proxyOptions.addChangeListener(new ProxyChangeListener(null));
    }

    private static void installIdeProxySelector() {
        SystemProxySettings.initSystemProxyVariablesIfNecessary();
        IdeProxySelector ps = new IdeProxySelector(ProxySelector.getDefault());
        ProxySelector.setDefault(ps);
    }

    static void setHttpProxy(String host, String port, String excludes) {
        if (host == null) {
            return;
        }
        LOG.fine("Default HTTP proxy settings are set to: \n  http.proxyHost=" + host + "\n" + "  http.proxyPort=" + port + "\n" + "  http.nonProxyHosts=" + excludes);
        if (host != null) {
            System.setProperty("http.proxyHost", host);
        } else {
            System.clearProperty("http.proxyHost");
        }
        if (port != null) {
            System.setProperty("http.proxyPort", port == null ? "80" : port);
        } else {
            System.clearProperty("http.proxyPort");
        }
        if (excludes != null) {
            System.setProperty("http.nonProxyHosts", excludes);
        } else {
            System.clearProperty("http.nonProxyHosts");
        }
    }

    private class ProxyChangeListener
    implements ChangeListener {
        private ProxyOptions _proxyOptions = null;

        public ProxyChangeListener(ProxyOptions initialProxyOptions) {
            if (initialProxyOptions != null) {
                this.setProxyOptions(initialProxyOptions);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            ProxyOptions modifiedProxyOptions = (ProxyOptions)((Object)e.getSource());
            if (this._proxyOptions == null || !this._proxyOptions.equals((Object)modifiedProxyOptions)) {
                modifiedProxyOptions.applyToCurrentVM();
                this.setProxyOptions(modifiedProxyOptions);
            }
        }

        private void setProxyOptions(ProxyOptions newProxyOptions) {
            if (this._proxyOptions == null) {
                this._proxyOptions = new ProxyOptions();
            }
            newProxyOptions.copyTo((Object)this._proxyOptions);
        }
    }
}

