/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class BrowserListTable
extends JTable {
    private boolean USE_RADIO_BUTTON = true;

    public BrowserListTable(TableModel dataModel) {
        super(dataModel);
        TableColumnModel colModel = this.getColumnModel();
        TableColumn pathColumn = colModel.getColumn(2);
        TableColumn paramColumn = colModel.getColumn(3);
        TableColumn iconColumn = colModel.getColumn(4);
        colModel.removeColumn(pathColumn);
        colModel.removeColumn(paramColumn);
        colModel.removeColumn(iconColumn);
        TableColumn defaultColumn = colModel.getColumn(0);
        defaultColumn.setResizable(true);
        defaultColumn.setPreferredWidth(45);
        TableColumn nameColumn = colModel.getColumn(1);
        nameColumn.setResizable(true);
        defaultColumn.setMaxWidth(Short.MAX_VALUE);
        defaultColumn.setCellRenderer(new RadioButtonRenderer());
        defaultColumn.setCellEditor(new RadioButtonEditor(new JCheckBox()));
    }

    public void scrollToVisible(int rowIndex, int colIndex) {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport viewport = (JViewport)this.getParent();
        Rectangle rect = this.getCellRect(rowIndex, colIndex, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
    }

    class RadioButtonEditor
    extends DefaultCellEditor {
        private JPanel panel;
        private JToggleButton button;
        private JTable table;
        private int row;

        public RadioButtonEditor(JCheckBox checkBox) {
            super(checkBox);
            this.button = BrowserListTable.this.USE_RADIO_BUTTON ? new JRadioButton() : new JCheckBox();
            this.panel = new JPanel(new BorderLayout());
            this.panel.setOpaque(true);
            this.panel.add((Component)this.button, "Center");
            for (MouseListener l : this.button.getMouseListeners()) {
                this.button.removeMouseListener(l);
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                return null;
            }
            TableModel model = table.getModel();
            for (int i = 0; i < table.getRowCount(); ++i) {
                model.setValueAt(i == row, i, 0);
            }
            this.panel.setBackground(table.getSelectionBackground());
            this.button.setOpaque(false);
            this.button.setSelected(true);
            this.table = table;
            this.row = row;
            TableColumn defaultColumn = table.getColumnModel().getColumn(0);
            int leftOffset = defaultColumn.getPreferredWidth() / 2 - (int)this.button.getPreferredSize().getWidth() / 2;
            this.panel.setBorder(BorderFactory.createEmptyBorder(0, leftOffset, 0, 0));
            return this.panel;
        }

        @Override
        public Object getCellEditorValue() {
            return this.button.isSelected();
        }
    }

    class RadioButtonRenderer
    implements TableCellRenderer {
        private JPanel panel;
        private JToggleButton button;

        public RadioButtonRenderer() {
            this.button = BrowserListTable.this.USE_RADIO_BUTTON ? new JRadioButton() : new JCheckBox();
            this.panel = new JPanel(new BorderLayout());
            this.panel.setOpaque(true);
            this.panel.setBackground(Color.WHITE);
            this.panel.add((Component)this.button, "Center");
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                return null;
            }
            TableModel model = table.getModel();
            boolean isDefault = (Boolean)model.getValueAt(row, 0);
            this.button.setSelected(isDefault);
            this.button.setOpaque(false);
            TableColumn defaultColumn = table.getColumnModel().getColumn(0);
            int leftOffset = defaultColumn.getPreferredWidth() / 2 - (int)this.button.getPreferredSize().getWidth() / 2;
            Color focusedButtonColor = UIManager.getColor("Button.focus");
            if (hasFocus && focusedButtonColor != null) {
                this.panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(focusedButtonColor, 1), BorderFactory.createEmptyBorder(0, leftOffset - 1, 0, 0)));
            } else {
                this.panel.setBorder(BorderFactory.createEmptyBorder(0, leftOffset, 0, 0));
            }
            if (isSelected) {
                this.panel.setBackground(table.getSelectionBackground());
            } else {
                this.panel.setBackground(table.getBackground());
            }
            return this.panel;
        }
    }
}

