/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.ide.config.Preferences;
import oracle.ide.webbrowser.Cookie;
import oracle.ideimpl.webbrowser.WocPreferences;
import oracle.javatools.data.PropertyStorage;

public final class WOCAuthenticator {
    private static final String AUTH_SERVER_DEFAULT = "https://login.oracle.com/sso/auth";
    private static final String SITE_2_PSTORE_TOKEN = "site2pstoretoken";
    private String _authServerUrl = "https://login.oracle.com/sso/auth";
    private final String _originalContentUrl;
    private String _downloadLocation;

    public WOCAuthenticator(URL contentUrl) {
        this._originalContentUrl = contentUrl.toString();
    }

    public void setAuthenticationServerUrl(URL url) {
        if (url != null) {
            this._authServerUrl = url.toString();
        }
    }

    public PasswordAuthentication getRememberedAuthentication() {
        WocPreferences prefs = WocPreferences.getInstance((PropertyStorage)Preferences.getPreferences());
        if (prefs.getOTNData() == null) {
            return null;
        }
        return new PasswordAuthentication(prefs.getUser().trim(), prefs.getOTNData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationToken logIn(PasswordAuthentication credentials) throws IOException {
        AuthenticationToken authenticationToken = null;
        this.checkForLocalHost();
        String username = credentials.getUserName();
        String password = new String(credentials.getPassword());
        HttpURLConnection conn = null;
        try {
            Map tokenMap = this.followRedirectsToFindTokens(this._originalContentUrl);
            if (tokenMap.get(SITE_2_PSTORE_TOKEN) == null) {
                throw new IOException("Unable to authenticate with OTN.");
            }
            String submitUrl = this.getAuthenticatedUrl(username, password, tokenMap);
            URL newURL = new URL(submitUrl);
            conn = (HttpURLConnection)newURL.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode != 302) {
                throw new IOException("Unable to authenticate with OTN.");
            }
            authenticationToken = this.retrieveAuthenticationTokens(conn);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return authenticationToken;
    }

    private AuthenticationToken retrieveAuthenticationTokens(HttpURLConnection conn) {
        String keyName;
        AuthenticationToken authenticationToken = null;
        ArrayList<Cookie> retreivedCookies = new ArrayList<Cookie>();
        this._downloadLocation = conn.getHeaderField("Location");
        int i = 1;
        while ((keyName = conn.getHeaderFieldKey(i)) != null) {
            String value = conn.getHeaderField(i);
            if ("Set-Cookie".equals(keyName)) {
                Cookie cookie = new Cookie();
                cookie.parse(value);
                retreivedCookies.add(cookie);
            }
            ++i;
        }
        if (this._downloadLocation != null && !retreivedCookies.isEmpty()) {
            authenticationToken = new AuthenticationToken(this._downloadLocation, retreivedCookies);
        }
        return authenticationToken;
    }

    private String getAuthenticatedUrl(String userName, String password, Map tokenMap) throws IOException {
        String p_submit_url = this._authServerUrl;
        String site2PToken = (String)tokenMap.get(SITE_2_PSTORE_TOKEN);
        String submitUrl = p_submit_url + "?" + SITE_2_PSTORE_TOKEN + "=" + site2PToken + "&ssousername=" + userName + "&password=" + password;
        return submitUrl;
    }

    private Map getParsedTokens(String inputUrl) {
        HashMap<String, String> map = new HashMap<String, String>();
        String[] mainSplit = inputUrl.split("\\?");
        map.put("p_submit_url", mainSplit[0]);
        if (mainSplit.length == 2) {
            String[] paramsArray = mainSplit[1].split("&");
            for (int i = 0; i < paramsArray.length; ++i) {
                String[] paramArray = paramsArray[i].split("=");
                if (paramArray.length == 1) {
                    map.put(paramArray[0], "");
                }
                if (paramArray.length != 2) continue;
                map.put(paramArray[0], paramArray[1]);
            }
        }
        return map;
    }

    private Map followRedirectsToFindTokens(String startingUrl) throws IOException {
        String url = startingUrl;
        Map tokenMap = null;
        while (tokenMap == null) {
            HttpURLConnection conn = null;
            try {
                URL newURL = new URL(url);
                conn = (HttpURLConnection)newURL.openConnection();
                conn.setRequestMethod("GET");
                conn.setDoOutput(true);
                conn.setInstanceFollowRedirects(false);
                conn.connect();
                int responseCode = conn.getResponseCode();
                if (responseCode == 302) {
                    url = conn.getHeaderField("Location");
                    continue;
                }
                if (responseCode == 301) {
                    url = conn.getHeaderField("Location");
                    tokenMap = this.getParsedTokens(url);
                    continue;
                }
                throw new IOException("Unable to authenticate with OTN.");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                throw ioe;
            }
            finally {
                if (conn == null) continue;
                conn.disconnect();
            }
        }
        return tokenMap;
    }

    private void checkForLocalHost() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            localHost.getHostAddress();
        }
        catch (Exception uhe) {
            uhe.printStackTrace();
            throw new IllegalStateException("Localhost appears to be an unknown host: " + uhe.getMessage());
        }
    }

    public static void endorse(URLConnection conn, AuthenticationToken token) {
        if (conn == null) {
            throw new NullPointerException("conn is null");
        }
        if (token == null) {
            throw new NullPointerException("token is null");
        }
        String existingCookies = conn.getRequestProperty("Cookie");
        if (existingCookies == null) {
            existingCookies = "";
        }
        StringBuffer allCookies = new StringBuffer(existingCookies);
        if ((existingCookies = existingCookies.trim()).length() > 0 && ';' != existingCookies.charAt(existingCookies.length() - 1)) {
            allCookies.append(";");
        }
        Iterator i = token.getCookies().iterator();
        while (i.hasNext()) {
            Cookie cookie = (Cookie)i.next();
            if (cookie != null) {
                allCookies.append(cookie.toSimpleString());
            }
            if (!i.hasNext()) continue;
            allCookies.append(";");
        }
        conn.setRequestProperty("Cookie", allCookies.toString());
    }

    public static final class AuthenticationToken {
        private final String _downloadUrl;
        private final List _cookies;

        private AuthenticationToken(String downloadUrl, List cookies) {
            this._downloadUrl = downloadUrl;
            this._cookies = cookies;
        }

        private List getCookies() {
            return this._cookies;
        }

        public String getDownloadUrl() {
            return this._downloadUrl;
        }
    }
}

