/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import java.awt.Color;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.EnvironOptions;
import oracle.ide.help.HelpInfo;
import oracle.ide.help.Helpable;
import oracle.ide.layout.IdeLayout;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.log.LogPage;
import oracle.ide.model.Attributes;
import oracle.ide.model.Displayable;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.RunMgrArb;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.DontStartNoMessageError;
import oracle.ide.runner.LogOutputThread;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcessLifecycleEvent;
import oracle.ide.runner.RunProcessLifecycleListener;
import oracle.ide.runner.RunProcessListener;
import oracle.ide.runner.RunnableItem;
import oracle.ide.runner.Runner;
import oracle.ide.runner.Starter;
import oracle.ide.runner.StarterCookieList;
import oracle.ide.runner.StarterFactory;
import oracle.ide.runner.StarterFactoryChoiceDialog;
import oracle.ide.util.Assert;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.runner.RunnerBundle;
import oracle.javatools.util.ModelUtil;
import org.netbeans.api.progress.ProgressHandle;

public abstract class RunProcess
implements Element,
Helpable {
    public static String RUN_PROCESS_USE_NODE_FROM_CONTEXT = "RUN_PROCESS_USE_NODE_FROM_CONTEXT";
    public static String RUN_PROCESS_DO_NOT_CONSIDER_DEFAULT = "RUN_PROCESS_DO_NOT_CONSIDER_DEFAULT";
    protected long timeCreated;
    protected Context context;
    protected boolean logStartDirectory;
    protected boolean logCommandString;
    protected boolean logOutput;
    private List duplicateOutput;
    protected boolean allowInput;
    protected boolean logError;
    private List duplicateError;
    protected boolean logExit;
    protected boolean showStartStatus;
    protected boolean addToProcessesFolder;
    protected boolean addToTerminateMenu;
    protected boolean hideTerminateAction;
    protected boolean useLogPage;
    protected boolean useLogPageQuietly;
    protected LogPage logPageOverride;
    private boolean suppressLogging;
    protected RunProcessListener runProcessListener;
    protected boolean userCanceled;
    protected List errors;
    protected boolean determineTargetAndStarterAlready = false;
    protected String labelOverride;
    protected String labelPrefixOverride;
    protected Icon iconOverride;
    protected Node target;
    protected Starter starter;
    protected RunProcess container;
    protected boolean useContainerLogPage = false;
    protected boolean isPreparingLabel = false;
    private ProgressHandle progressHandle;
    private Object progressHandleOwner = null;
    private boolean progressHandleActive = false;
    private LogOutputThread logSystemOutThread;
    private LogOutputThread logSystemErrThread;
    private boolean processNodeAdded;
    private boolean terminateMenuAdded;
    private boolean finished;
    private boolean finishedPreparing;
    private Attributes attributes = new ElementAttributes(ElementAttributes.NONE);
    private Runner runner = Runner.getRunner();
    private static int systemOutColor;
    private static SimpleAttributeSet systemOutAttributeSet;
    private static int systemErrColor;
    private static SimpleAttributeSet systemErrAttributeSet;
    private LogPage logPage;

    public RunProcess(Context context) {
        this.timeCreated = System.currentTimeMillis();
        this.context = context;
        this.logStartDirectory = true;
        this.logCommandString = true;
        this.logOutput = true;
        this.allowInput = false;
        this.logError = true;
        this.logExit = false;
        this.showStartStatus = true;
        this.addToProcessesFolder = true;
        this.addToTerminateMenu = true;
        this.hideTerminateAction = false;
        this.useLogPage = true;
        this.useLogPageQuietly = false;
        this.logPageOverride = null;
        this.suppressLogging = false;
        this.labelPrefixOverride = null;
        this.iconOverride = null;
        this.errors = new ArrayList();
        this.container = null;
        this.useContainerLogPage = false;
    }

    protected Object copyTo(Object o) {
        if (o == null) {
            throw new IllegalStateException();
        }
        RunProcess other = (RunProcess)o;
        other.context = this.context;
        other.useLogPage = this.useLogPage;
        other.useLogPageQuietly = this.useLogPageQuietly;
        other.logPageOverride = this.logPageOverride;
        other.suppressLogging = this.suppressLogging;
        other.allowInput = this.allowInput;
        other.logStartDirectory = this.logStartDirectory;
        other.logCommandString = this.logCommandString;
        other.showStartStatus = this.showStartStatus;
        other.addToProcessesFolder = this.addToProcessesFolder;
        other.addToTerminateMenu = this.addToTerminateMenu;
        other.hideTerminateAction = this.hideTerminateAction;
        other.runProcessListener = this.runProcessListener;
        other.logError = this.logError;
        other.logOutput = this.logOutput;
        other.labelPrefixOverride = this.labelPrefixOverride;
        other.iconOverride = this.iconOverride;
        other.container = this.container;
        other.useContainerLogPage = this.useContainerLogPage;
        return other;
    }

    public final void setLogOutput(boolean logOutput) {
        this.logOutput = logOutput;
    }

    public final void setLogError(boolean logError) {
        this.logError = logError;
    }

    public PipedInputStream duplicateOutputStream() {
        PipedInputStream pis = new PipedInputStream();
        if (this.duplicateOutput == null) {
            this.duplicateOutput = new ArrayList();
        }
        this.duplicateOutput.add(pis);
        return pis;
    }

    public PipedInputStream duplicateErrorStream() {
        PipedInputStream pis = new PipedInputStream();
        if (this.duplicateError == null) {
            this.duplicateError = new ArrayList();
        }
        this.duplicateError.add(pis);
        return pis;
    }

    protected Class getStarterFactorySubClass() {
        return StarterFactory.class;
    }

    protected void determineTargetAndStarter() {
        if (this.determineTargetAndStarterAlready || this.target != null) {
            return;
        }
        this.determineTargetAndStarter(this.getStarterFactorySubClass());
        this.determineTargetAndStarterAlready = true;
    }

    public static Node getContextNodeForRun(Context context) {
        int length;
        if (context == null) {
            return null;
        }
        if (context.containsProperty(RUN_PROCESS_USE_NODE_FROM_CONTEXT) && context.getNode() != null) {
            return context.getNode();
        }
        Element[] selection = context.getSelection();
        if (selection != null && (length = selection.length) > 0 && selection[0] instanceof Node) {
            if (length == 1) {
                Node result = (Node)selection[0];
                return result instanceof Workspace ? null : result;
            }
            Node runnable = null;
            Runner runner = Runner.getRunner();
            for (int i = 0; i < length; ++i) {
                Element element = selection[i];
                if (!(element instanceof Node) || !runner.couldNodeBeRunnable((Node)element)) continue;
                if (runnable == null) {
                    runnable = (Node)element;
                    continue;
                }
                return null;
            }
            return runnable;
        }
        return context.getNode();
    }

    protected void determineTargetAndStarter(Class starterFactorySubClass) {
        boolean needToAddError = true;
        Node contextNode = RunProcess.getContextNodeForRun(this.context);
        if (contextNode != null && !(contextNode instanceof Project)) {
            Node node = contextNode;
            Project project = this.context != null ? this.context.getProject() : null;
            boolean addExtraError = true;
            boolean couldNodeBeRunnable = Runner.getRunner().couldNodeBeRunnable(node, starterFactorySubClass);
            if (couldNodeBeRunnable) {
                int errorCountBeforeGetStarter = this.errors.size();
                Starter s = null;
                try {
                    s = this.getStarterForTarget(project, node, starterFactorySubClass);
                }
                catch (DontStartNoMessageError dsnme) {
                    couldNodeBeRunnable = true;
                    addExtraError = false;
                }
                if (s != null) {
                    this.target = node;
                    this.starter = s;
                    return;
                }
                boolean bl = needToAddError = this.errors.size() == errorCountBeforeGetStarter;
            }
            if (needToAddError && addExtraError) {
                String error = RunMgrArb.format((int)1, (Object)contextNode.getShortLabel());
                this.errors.add(error);
            }
        } else if (needToAddError && (this.context == null || this.context.getProject() == null)) {
            String error = RunMgrArb.getString((int)0);
            this.errors.add(error);
        }
    }

    @Deprecated
    protected Starter getStarterForTarget(Node node, Class starterFactorySubClass) {
        return this.getStarterForTarget(null, node, starterFactorySubClass);
    }

    protected Starter getStarterForTarget(Project project, Node node, Class starterFactorySubClass) {
        block16: {
            if (this.userCanceled) {
                return null;
            }
            if (node != null) {
                URL url = node.getURL();
                if (url == null) {
                    throw new IllegalArgumentException("Null node URL for " + node.getShortLabel() + " of type " + node.getClass().getName());
                }
                if (!url.getProtocol().equalsIgnoreCase("file") || URLFileSystem.exists((URL)url)) {
                    AbstractStarterFactory[] starterFactories = Runner.getRunner().getStarterFactoriesForTarget(project, node, starterFactorySubClass);
                    int length = starterFactories.length;
                    ArrayList<AbstractStarterFactory> goodStarterFactories = new ArrayList<AbstractStarterFactory>();
                    ArrayList<Object> cookies = new ArrayList<Object>();
                    for (int i = 0; i < length; ++i) {
                        AbstractStarterFactory abstractStarterFactory = starterFactories[i];
                        Object cookie = abstractStarterFactory.canStart(this, this.context, node, this.errors);
                        if (cookie == null) continue;
                        if (cookie instanceof StarterCookieList) {
                            StarterCookieList starterCookieList = (StarterCookieList)cookie;
                            int size = starterCookieList.size();
                            for (int ii = 0; ii < size; ++ii) {
                                Object o = starterCookieList.get(ii);
                                goodStarterFactories.add(abstractStarterFactory);
                                cookies.add(o);
                            }
                            continue;
                        }
                        goodStarterFactories.add(abstractStarterFactory);
                        cookies.add(cookie);
                    }
                    if (!goodStarterFactories.isEmpty()) {
                        int index = 0;
                        int size = goodStarterFactories.size();
                        if (size > 1) {
                            Displayable[] displayables = new Displayable[size];
                            for (int i = 0; i < size; ++i) {
                                AbstractStarterFactory abstractStarterFactory = (AbstractStarterFactory)goodStarterFactories.get(i);
                                Object cookie = cookies.get(i);
                                displayables[i] = abstractStarterFactory.getDisplayable(this, this.context, node, cookie);
                            }
                            index = StarterFactoryChoiceDialog.showStarterFactoryChoiceDialog(node, displayables);
                            if (index == -1) {
                                this.userCanceled = true;
                                return null;
                            }
                        }
                        try {
                            AbstractStarterFactory abstractStarterFactory = (AbstractStarterFactory)goodStarterFactories.get(index);
                            Object cookie = cookies.get(index);
                            Starter starter = abstractStarterFactory.createStarter(this, this.context, node, cookie);
                            if (this.checkStarter(starter, this.errors)) {
                                return starter;
                            }
                        }
                        catch (RuntimeException e) {
                            String msg = e.getMessage();
                            if (msg != null && msg.indexOf("user canceled") >= 0) {
                                this.userCanceled = true;
                                break block16;
                            }
                            Logger.getLogger("oracle.ide.runner").log(Level.SEVERE, "Unable to initialize starter for run/debug:", e);
                        }
                    }
                } else {
                    String error = RunMgrArb.format((int)4, (Object)node.getShortLabel());
                    this.errors.add(error);
                }
            }
        }
        return null;
    }

    public RunnableItem[] getRunnableItems() {
        Class starterFactorySubClass = this.getStarterFactorySubClass();
        Node contextNode = RunProcess.getContextNodeForRun(this.context);
        if (contextNode != null && !(contextNode instanceof Workspace) && !(contextNode instanceof Project)) {
            Node node = contextNode;
            if (Runner.getRunner().couldNodeBeRunnable(node, starterFactorySubClass)) {
                Project project = this.context != null ? this.context.getProject() : null;
                return this.getRunnableItemsForTarget(project, node, starterFactorySubClass);
            }
        }
        return null;
    }

    @Deprecated
    protected RunnableItem[] getRunnableItemsForTarget(Node node, Class starterFactorySubClass) {
        return this.getRunnableItemsForTarget(null, node, starterFactorySubClass);
    }

    protected RunnableItem[] getRunnableItemsForTarget(Project project, Node node, Class starterFactorySubClass) {
        if (node != null) {
            URL url = node.getURL();
            if (url == null) {
                throw new IllegalArgumentException("Null node URL for " + node.getShortLabel() + " of type " + node.getClass().getName());
            }
            if (!url.getProtocol().equalsIgnoreCase("file") || URLFileSystem.exists((URL)url)) {
                AbstractStarterFactory[] starterFactories = Runner.getRunner().getStarterFactoriesForTarget(project, node, starterFactorySubClass);
                int length = starterFactories.length;
                ArrayList<AbstractStarterFactory> goodStarterFactories = new ArrayList<AbstractStarterFactory>();
                ArrayList<Object> cookies = new ArrayList<Object>();
                for (int i = 0; i < length; ++i) {
                    AbstractStarterFactory abstractStarterFactory = starterFactories[i];
                    Object cookie = abstractStarterFactory.canStart(this, this.context, node, this.errors);
                    if (cookie == null) continue;
                    if (cookie instanceof StarterCookieList) {
                        StarterCookieList starterCookieList = (StarterCookieList)cookie;
                        int size = starterCookieList.size();
                        for (int ii = 0; ii < size; ++ii) {
                            Object o = starterCookieList.get(ii);
                            goodStarterFactories.add(abstractStarterFactory);
                            cookies.add(o);
                        }
                        continue;
                    }
                    goodStarterFactories.add(abstractStarterFactory);
                    cookies.add(cookie);
                }
                if (!goodStarterFactories.isEmpty()) {
                    int size = goodStarterFactories.size();
                    RunnableItem[] runnableItems = new RunnableItem[size];
                    for (int i = 0; i < size; ++i) {
                        AbstractStarterFactory abstractStarterFactory = (AbstractStarterFactory)goodStarterFactories.get(i);
                        Object cookie = cookies.get(i);
                        runnableItems[i] = new RunnableItem(this, this.context, node, abstractStarterFactory, cookie);
                    }
                    return runnableItems;
                }
            }
        }
        return null;
    }

    @Deprecated
    public String canGetStarterForTarget(Node node, Class starterFactorySubClass, List errors) {
        return this.canGetStarterForTarget(null, node, starterFactorySubClass, errors);
    }

    public String canGetStarterForTarget(Project project, Node node, Class starterFactorySubClass, List errors) {
        if (node != null) {
            int errorCountBefore = errors.size();
            for (AbstractStarterFactory abstractStarterFactory : Runner.getRunner().getStarterFactoriesForTarget(project, node, starterFactorySubClass)) {
                Object cookie = abstractStarterFactory.canStart(this, this.context, node, errors);
                if (cookie == null) continue;
                return abstractStarterFactory.getName();
            }
            if (errors.size() == errorCountBefore) {
                String error = RunMgrArb.format((int)1, (Object)node.getShortLabel());
                errors.add(error);
            }
        }
        return null;
    }

    protected boolean checkStarter(Starter starter, List errors) {
        return starter.canStart(errors);
    }

    public long getTimeCreated() {
        return this.timeCreated;
    }

    public Context getContext() {
        return this.context;
    }

    public Workspace getWorkspace() {
        Workspace workspace = this.context.getWorkspace();
        if (workspace == null) {
            workspace = Ide.getDefaultWorkspace();
        }
        return workspace;
    }

    public Project getProject() {
        return RunProcess.getProject(this.context);
    }

    public static Project getProject(Context context) {
        Project project;
        if (context != null) {
            if (context.getProject() != null) {
                return context.getProject();
            }
            if (context.getBoolean("Context.INTENTIONAL_NULL")) {
                return null;
            }
        }
        if ((project = Ide.getActiveProject()) == null) {
            project = Ide.getDefaultProject();
        }
        return project;
    }

    public boolean canRun(String runType, Object cookie, Node node, List<String> errors) {
        return false;
    }

    public Object getValue(String runType, Object cookie, String key) {
        return null;
    }

    public final Node getTarget() {
        return this.getTarget(true);
    }

    public final Node getTarget(boolean determineTargetAndStarter) {
        if (determineTargetAndStarter) {
            this.determineTargetAndStarter();
        }
        return this.target;
    }

    public final Starter getStarter() {
        return this.getStarter(true);
    }

    public final Starter getStarter(boolean determineTargetAndStarter) {
        if (determineTargetAndStarter) {
            this.determineTargetAndStarter();
        }
        return this.starter;
    }

    public boolean canStart() {
        this.determineTargetAndStarter();
        return this.starter != null;
    }

    protected boolean isStartOnly() {
        if (this.starter != null) {
            return this.starter.isStartOnly();
        }
        return false;
    }

    public boolean canContainRunProcesses() {
        if (this.starter != null) {
            return this.starter.canContainRunProcesses();
        }
        return false;
    }

    public void start(Node node, AbstractStarterFactory abstractStarterFactory, Object cookie) {
        this.determineTargetAndStarterAlready = true;
        this.target = node;
        this.starter = abstractStarterFactory.createStarter(this, this.context, node, cookie);
        if (this.checkStarter(this.starter, this.errors)) {
            this.start();
        } else {
            this.logStartErrors();
        }
    }

    public void start() {
        if (this.progressHandle == null) {
            this.initProgressHandle(RunnerBundle.get("TASK_PROGRESS_LAUNCHING"), -1);
        }
        this.updateProgressHandle(RunnerBundle.get("TASK_PROGRESS_START_DETERMINE_T_S"));
        this.determineTargetAndStarter();
        this.updateProgressHandle(RunnerBundle.get("TASK_PROGRESS_FINISH_DETERMINE_T_S"));
        if (this.mustPrepareToStart()) {
            Thread prepareThread = new Thread("RunProcess-PrepareToStart"){

                @Override
                public void run() {
                    block5: {
                        block4: {
                            boolean prepared = false;
                            try {
                                prepared = RunProcess.this.prepareToStart();
                                if (!prepared) break block4;
                            }
                            catch (Throwable throwable) {
                                if (prepared) {
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            RunProcess.this.updateProgressHandle(RunnerBundle.get("TASK_PROGRESS_STARTING_TARGET"));
                                            boolean started = false;
                                            try {
                                                started = RunProcess.this.startTarget();
                                            }
                                            finally {
                                                if (!started) {
                                                    RunProcess.this.finishProgressHandle();
                                                }
                                            }
                                        }
                                    });
                                } else {
                                    RunProcess.this.finishProgressHandle();
                                }
                                throw throwable;
                            }
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            break block5;
                        }
                        RunProcess.this.finishProgressHandle();
                    }
                }
            };
            prepareThread.start();
        } else {
            this.updateProgressHandle(RunnerBundle.get("TASK_PROGRESS_STARTING_TARGET"));
            boolean started = false;
            try {
                started = this.startTarget();
            }
            finally {
                if (!started) {
                    this.finishProgressHandle();
                }
            }
        }
    }

    protected boolean mustPrepareToStart() {
        this.determineTargetAndStarter();
        if (this.starter != null) {
            return this.starter.mustPrepareToStart();
        }
        return false;
    }

    protected boolean prepareToStart() {
        this.finishedPreparing = false;
        this.determineTargetAndStarter();
        if (this.starter != null) {
            boolean canTerminateDuringPrepare = this.starter.canTerminate();
            if (canTerminateDuringPrepare && (this.addToProcessesFolder || this.addToTerminateMenu || this.getUseLogPage() && (this.logPageOverride == null || this.logPageOverride instanceof RunLogPage))) {
                this.doUI(new Runnable(){

                    @Override
                    public void run() {
                        RunLogPage runLogPage;
                        LogPage lp;
                        if (RunProcess.this.addToProcessesFolder) {
                            Runner.getRunner().getProcessesFolder().add((Element)RunProcess.this);
                            RunProcess.this.processNodeAdded = true;
                        }
                        if (RunProcess.this.addToTerminateMenu && RunProcess.this.canTerminate()) {
                            Runner.getRunner().addTerminateMenu(RunProcess.this);
                            RunProcess.this.terminateMenuAdded = true;
                        }
                        if (RunProcess.this.getUseLogPage() && (lp = RunProcess.this.getLogPage()) instanceof RunLogPage && !(runLogPage = (RunLogPage)lp).preparing(RunProcess.this)) {
                            RunProcess.this.terminate();
                        }
                    }
                });
            }
            this.firePreparingToStart(new RunProcessLifecycleEvent(this, this.getContext()), canTerminateDuringPrepare);
            final boolean startedOK = this.starter.prepareToStart();
            if (canTerminateDuringPrepare) {
                this.doUI(new Runnable(){

                    @Override
                    public void run() {
                        RunProcess.this.finishedPreparingToStart();
                        if (!startedOK) {
                            IdeMainWindow.updateVisibleActions();
                            RunProcess.this.fireFinished(new RunProcessLifecycleEvent(RunProcess.this, RunProcess.this.getContext()));
                        }
                    }
                });
            }
            this.finishedPreparing = true;
            return startedOK;
        }
        this.finishedPreparing = true;
        return true;
    }

    public synchronized void finishedPreparingToStart() {
        Assert.checkAWTThread();
        if (!this.finishedPreparing) {
            this.finishedPreparing = true;
            if (this.processNodeAdded) {
                Runner.getRunner().getProcessesFolder().remove((Element)this);
            }
            if (this.terminateMenuAdded) {
                Runner.getRunner().removeTerminateMenu(this);
            }
            this.redirectInput(null);
            LogPage lp = this.getLogPage();
            if (lp != null && lp instanceof RunLogPage) {
                RunLogPage runLogPage = (RunLogPage)lp;
                runLogPage.finishedPreparing(this);
            }
            IdeMainWindow.updateVisibleActions();
            this.fireFinishedPreparing(new RunProcessLifecycleEvent(this, this.getContext()));
        }
    }

    protected boolean startTarget() {
        this.determineTargetAndStarter();
        if (this.starter != null) {
            this.errors.clear();
            if (this.starter.start()) {
                this.started();
                return true;
            }
        }
        if (this.userCanceled) {
            this.errors.clear();
        } else {
            this.logStartErrors();
        }
        this.notifyRunProcessListener(Integer.MIN_VALUE);
        this.finishProgressHandle();
        return false;
    }

    protected void logStartErrors() {
        LogPage logPage;
        if (!this.errors.isEmpty() && (logPage = this.getLogPage()) != null) {
            for (String s : this.errors) {
                this.logMessage(logPage, s + "\n");
            }
            this.errors.clear();
        }
    }

    public void started() {
        if (this.addToProcessesFolder || this.addToTerminateMenu || this.getUseLogPage() && (this.logPageOverride == null || this.logPageOverride instanceof RunLogPage)) {
            this.doUI(new Runnable(){

                @Override
                public void run() {
                    RunLogPage runLogPage;
                    LogPage lp;
                    if (RunProcess.this.addToProcessesFolder) {
                        Runner.getRunner().getProcessesFolder().add((Element)RunProcess.this);
                        RunProcess.this.processNodeAdded = true;
                    }
                    if (RunProcess.this.addToTerminateMenu && RunProcess.this.canTerminate()) {
                        Runner.getRunner().addTerminateMenu(RunProcess.this);
                        RunProcess.this.terminateMenuAdded = true;
                    }
                    if (RunProcess.this.getUseLogPage() && (lp = RunProcess.this.getLogPage()) instanceof RunLogPage && !(runLogPage = (RunLogPage)lp).started(RunProcess.this)) {
                        RunProcess.this.terminate();
                    }
                }
            });
        }
        this.fireStarted(new RunProcessLifecycleEvent(this, this.getContext()), this.addToTerminateMenu);
        if (this.progressHandleOwner == null) {
            this.finishProgressHandle();
        }
    }

    protected void firePreparingToStart(RunProcessLifecycleEvent event, boolean userCanTerminate) {
        Runner runner = Runner.getRunner();
        if (runner != null) {
            List<RunProcessLifecycleListener> listeners = runner.getLifecycleListeners(this.getContext());
            for (int i = listeners.size() - 1; i >= 0; --i) {
                listeners.get(i).preparing(event, userCanTerminate);
            }
        }
    }

    protected void fireFinishedPreparing(RunProcessLifecycleEvent event) {
        Runner runner = Runner.getRunner();
        if (runner != null) {
            List<RunProcessLifecycleListener> listeners = runner.getLifecycleListeners(this.getContext());
            for (int i = listeners.size() - 1; i >= 0; --i) {
                listeners.get(i).finishedPreparing(event);
            }
        }
    }

    protected void fireStarted(RunProcessLifecycleEvent event, boolean userCanTerminate) {
        Runner runner = Runner.getRunner();
        if (runner != null) {
            List<RunProcessLifecycleListener> listeners = runner.getLifecycleListeners(this.getContext());
            for (int i = listeners.size() - 1; i >= 0; --i) {
                listeners.get(i).started(event, userCanTerminate);
            }
        }
    }

    protected void fireFinished(RunProcessLifecycleEvent event) {
        Runner runner = Runner.getRunner();
        if (runner != null) {
            List<RunProcessLifecycleListener> listeners = runner.getLifecycleListeners(this.getContext());
            for (int i = listeners.size() - 1; i >= 0; --i) {
                listeners.get(i).finished(event);
            }
        }
    }

    public void redirectOutput(InputStream systemOutStream, InputStream systemErrStream) {
        LogPage logPage = this.getLogPage();
        String label = this.getShortLabel();
        String name = label + " System.out";
        this.logSystemOutThread = new LogOutputThread(name, this, (LogPage)(this.logOutput ? logPage : null), RunProcess.getSystemOutAttributeSet(), systemOutStream, this.duplicateOutput);
        this.logSystemOutThread.start();
        name = label + " System.err";
        this.logSystemErrThread = new LogOutputThread(name, this, (LogPage)(this.logError ? logPage : null), RunProcess.getSystemErrAttributeSet(), systemErrStream, this.duplicateError);
        this.logSystemErrThread.start();
    }

    public static synchronized SimpleAttributeSet getSystemOutAttributeSet() {
        if (systemOutAttributeSet == null) {
            systemOutAttributeSet = new SimpleAttributeSet();
        }
        EnvironOptions environOptions = Ide.getEnvironOptions();
        if (systemOutColor == 0 || systemOutColor != environOptions.getLogSystemOutColor()) {
            systemOutColor = environOptions.getLogSystemOutColor();
            StyleConstants.setForeground(systemOutAttributeSet, new Color(systemOutColor));
        }
        return systemOutAttributeSet;
    }

    public static synchronized SimpleAttributeSet getSystemErrAttributeSet() {
        if (systemErrAttributeSet == null) {
            systemErrAttributeSet = new SimpleAttributeSet();
        }
        EnvironOptions environOptions = Ide.getEnvironOptions();
        if (systemErrColor == 0 || systemErrColor != environOptions.getLogSystemErrColor()) {
            systemErrColor = environOptions.getLogSystemErrColor();
            StyleConstants.setForeground(systemErrAttributeSet, new Color(systemErrColor));
        }
        return systemErrAttributeSet;
    }

    public void redirectInput(OutputStream input) {
        LogPage lp;
        if (this.allowInput && (lp = this.getLogPage()) != null && lp instanceof RunLogPage) {
            RunLogPage runLogPage = (RunLogPage)lp;
            runLogPage.allowInput(this, input);
        }
    }

    public void waitForRedirectOutput() {
        if (SwingUtilities.isEventDispatchThread()) {
            return;
        }
        if (this.logSystemOutThread != null) {
            LogOutputThread.waitForOutput(this.logSystemOutThread);
        }
        if (this.logSystemErrThread != null) {
            LogOutputThread.waitForOutput(this.logSystemErrThread);
        }
    }

    void finishRedirectOutput() {
        this.waitForRedirectOutput();
        if (this.logSystemOutThread != null) {
            try {
                this.logSystemOutThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.logSystemErrThread != null) {
            try {
                this.logSystemErrThread.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String[] getStartEnvironmentParams() {
        return null;
    }

    public File getStartDirectory() {
        return null;
    }

    public void logStartDirectory() {
        LogPage logPage;
        File startDirectory;
        if (this.logStartDirectory && (startDirectory = this.starter.getStartDirectory()) != null && (logPage = this.getLogPage()) != null) {
            this.logMessage(logPage, startDirectory + ">\n");
        }
    }

    public String[] getStartCommand() {
        return null;
    }

    public void logCommandString(String[] command) {
        LogPage logPage = this.getLogPage();
        if (logPage != null) {
            if (this.logCommandString) {
                String logCommand = this.fixCommandStringForLog(command);
                this.logMessage(logPage, logCommand + "\n");
            } else {
                this.logMessage(logPage, "");
            }
        }
    }

    protected String fixCommandStringForLog(String[] command) {
        StringBuffer commandBuffer = new StringBuffer();
        for (int i = 0; i < command.length; ++i) {
            if (commandBuffer.length() > 0) {
                commandBuffer.append(' ');
            }
            if (!(!command[i].equals("") && command[i].indexOf(32) < 0 && command[i].indexOf(9) < 0 || command[i].startsWith("\"") && command[i].endsWith("\""))) {
                commandBuffer.append('\"');
                commandBuffer.append(command[i]);
                commandBuffer.append('\"');
                continue;
            }
            commandBuffer.append(command[i]);
        }
        return commandBuffer.toString();
    }

    public boolean showStartStatus() {
        return this.showStartStatus;
    }

    protected boolean getUseLogPage() {
        return this.useLogPage;
    }

    public void setUseLogPage(boolean useLogPage) {
        this.useLogPage = useLogPage;
    }

    protected boolean getUseLogPageQuietly() {
        return this.useLogPageQuietly;
    }

    protected void setUseLogPageQuietly(boolean quiet) {
        this.useLogPageQuietly = quiet;
    }

    protected boolean getUseContainerLogPage() {
        return this.useContainerLogPage;
    }

    public void setUseContainerLogPage(boolean useContainerLogPage) {
        this.useContainerLogPage = useContainerLogPage;
    }

    public LogPage getLogPage() {
        return this.getLogPage(true);
    }

    public LogPage getLogPage(boolean create) {
        if (!this.getUseLogPage()) {
            return null;
        }
        if (this.getUseContainerLogPage() && this.container != null) {
            return this.container.getLogPage();
        }
        if (this.logPage == null) {
            this.logPage = this.makeLogPage(create);
        }
        return this.logPage;
    }

    protected LogPage makeLogPage(boolean create) {
        if (this.logPageOverride != null) {
            return this.logPageOverride;
        }
        return RunLogPage.makePage(this, create);
    }

    protected boolean reuseLogPage(RunLogPage runLogPage) {
        Boolean reuse;
        if (!this.getUseLogPage()) {
            return false;
        }
        if (this.starter != null && (reuse = this.starter.reuseLogPage(runLogPage)) != null) {
            return reuse;
        }
        if (!runLogPage.isProcessAlive() && ModelUtil.areEqual((Object)this.getShortLabel(), (Object)runLogPage.getName()) && this.getWorkspace() == runLogPage.getWorkspace() && this.getProject() == runLogPage.getProject() && this.getIcon() == runLogPage.getTabIcon()) {
            if (ModelUtil.areEqual((Object)this.getToolTipText(), (Object)runLogPage.getToolTipText())) {
                if (ModelUtil.areEqual((Object)this.getShortLabelWithPrefix(), (Object)runLogPage.getTitleName())) {
                    if (this.getHelpInfo() == null || ModelUtil.areEqual((Object)this.getHelpInfo(), (Object)runLogPage.getHelpInfo())) {
                        return true;
                    }
                    Assert.println((String)"RunLogPage not reused because helpinfo is different.");
                } else {
                    Assert.println((String)"RunLogPage not reused because title is different.");
                }
            } else {
                Assert.println((String)"RunLogPage not reused because tooltip is different.");
            }
        }
        return false;
    }

    public boolean inheritLogPage(RunProcess rp) {
        if (this.logPage == null) {
            this.logPage = rp.logPage;
            return true;
        }
        return false;
    }

    public void log(Object msg) {
        LogPage lp = this.getLogPage();
        if (lp == null) {
            return;
        }
        if (lp instanceof RunLogPage) {
            ((RunLogPage)lp).logMessageFromRunner(msg);
        } else {
            lp.log(msg);
        }
    }

    public boolean doUILater() {
        return this.runner.isShuttingDown();
    }

    protected void doUI(Runnable r) {
        if (this.doUILater()) {
            SwingUtilities.invokeLater(r);
        } else {
            IdeUtil.runNow((Runnable)r);
        }
    }

    public boolean suppressDirectoryDefault() {
        return false;
    }

    public abstract String getProcessLabelPrefix();

    public IdeLayout getProcessLayout() {
        return null;
    }

    public void selected() {
    }

    public void doubleClicked() {
    }

    public void unselected() {
    }

    public String[] getTerminateCommand() {
        return null;
    }

    public boolean canTerminate() {
        if (this.starter != null) {
            if (this.starter.canTerminateGracefully()) {
                return true;
            }
            return this.starter.canTerminate();
        }
        return false;
    }

    public void terminate() {
        if (this.starter != null) {
            if (this.starter.canTerminateGracefully()) {
                this.starter.terminateGracefully();
            } else if (this.starter.canTerminate()) {
                this.starter.terminate();
            }
        }
    }

    public boolean hasFinished() {
        return this.finished;
    }

    public synchronized void finished() {
        Assert.checkAWTThread();
        if (!this.finished) {
            this.finished = true;
            if (this.processNodeAdded) {
                Runner.getRunner().getProcessesFolder().remove((Element)this);
            }
            if (this.terminateMenuAdded) {
                Runner.getRunner().removeTerminateMenu(this);
            }
            this.redirectInput(null);
            LogPage lp = this.getLogPage();
            if (lp != null && lp instanceof RunLogPage) {
                RunLogPage runLogPage = (RunLogPage)lp;
                runLogPage.finished(this);
            }
            if (this.starter != null) {
                Integer exitCode = this.starter.getExitCode();
                if (this.logExit) {
                    if (exitCode != null) {
                        this.log(RunMgrArb.format((int)7, (Object)exitCode.toString()));
                    } else {
                        this.log(RunMgrArb.getString((int)8));
                    }
                }
                int code = exitCode != null ? exitCode : -1;
                this.notifyRunProcessListener(code);
            }
            IdeMainWindow.updateVisibleActions();
            this.fireFinished(new RunProcessLifecycleEvent(this, this.getContext()));
        }
    }

    private void logMessage(LogPage log, Object message) {
        if (log instanceof AbstractLogPage && this.getUseLogPageQuietly()) {
            ((AbstractLogPage)log).logQuietly(message);
        } else {
            log.log(message);
        }
    }

    private void notifyRunProcessListener(int code) {
        RunProcessListener listener = this.runProcessListener;
        if (listener != null) {
            listener.processFinished(code);
        }
    }

    private String prepareLabel(boolean usePrefix, boolean useLong) {
        String s = "";
        if (!this.isPreparingLabel) {
            this.isPreparingLabel = true;
            this.determineTargetAndStarter();
            if (usePrefix || this.getIcon() == null) {
                s = this.getProcessLabelPrefix();
            }
            if (this.labelOverride != null) {
                s = s + this.labelOverride;
            } else {
                Project project = this.getProject();
                if (project != null && project != Ide.getDefaultProject()) {
                    s = s + (useLong ? project.getLongLabel() : project.getShortLabel());
                } else {
                    if ((s = s.trim()).endsWith(":") || s.endsWith("-")) {
                        s = s.substring(0, s.length() - 1);
                    }
                    s = s.trim();
                }
            }
            this.isPreparingLabel = false;
        }
        return s;
    }

    public void setHideTerminateAction(boolean hideTerminateAction) {
        this.hideTerminateAction = hideTerminateAction;
    }

    public void setLogPageOverride(LogPage logPageOverride) {
        this.logPageOverride = logPageOverride;
    }

    public void setSuppressLogging(boolean supress) {
        this.suppressLogging = supress;
    }

    public boolean getSuppressLogging() {
        return this.suppressLogging;
    }

    public void setLabelOverride(String labelOverride) {
        this.labelOverride = labelOverride;
    }

    public void setLabelPrefixOverride(String labelPrefixOverride) {
        this.labelPrefixOverride = labelPrefixOverride;
    }

    public void setIconOverride(Icon iconOverride) {
        this.iconOverride = iconOverride;
    }

    public void setLogStartDirectory(boolean logStartDirectory) {
        this.logStartDirectory = logStartDirectory;
    }

    public void setLogCommandString(boolean logCommandString) {
        this.logCommandString = logCommandString;
    }

    public void setLogExit(boolean logExit) {
        this.logExit = logExit;
    }

    public String getShortLabelWithPrefix() {
        return this.prepareLabel(true, false);
    }

    public RunProcess getContainer() {
        return this.container;
    }

    public void setContainer(RunProcess container) {
        this.container = container;
    }

    public String getShortLabel() {
        return this.prepareLabel(false, false);
    }

    public String getLongLabel() {
        return this.prepareLabel(true, true);
    }

    public Object getData() {
        return this;
    }

    public Icon getIcon() {
        return null;
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }

    public boolean mayHaveChildren() {
        return false;
    }

    public Iterator getChildren() {
        return null;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public HelpInfo getHelpInfo() {
        return null;
    }

    public String toString() {
        return this.getShortLabel();
    }

    public boolean canStopOnException() {
        return false;
    }

    public boolean canStopOnError() {
        return false;
    }

    public boolean canStopOnDebuggerStatement() {
        return false;
    }

    public boolean canTransferErrors() {
        return false;
    }

    public boolean getStopOnException() {
        return false;
    }

    public boolean getStopOnError() {
        return false;
    }

    public boolean getStopOnDebuggerStatement() {
        return false;
    }

    public boolean getTransferErrors() {
        return false;
    }

    public void setStopOnException(boolean b) {
    }

    public void setStopOnError(boolean b) {
    }

    public void setStopOnDebuggerStatement(boolean b) {
    }

    public void setTransferErrors(boolean b) {
    }

    public boolean getStopInChrome() {
        return false;
    }

    public void doGarbageCollection() {
    }

    public void setStopInChrome(boolean b) {
    }

    public boolean canStopInChrome() {
        return false;
    }

    public boolean canGarbageCollect() {
        return false;
    }

    public void initProgressHandle(String displayName, int numSteps) {
        this.progressHandle = ProgressHandle.createHandle((String)displayName);
        if (numSteps > 0) {
            this.progressHandle.start(numSteps);
        } else {
            this.progressHandle.start();
        }
        this.progressHandleActive = true;
    }

    public void initProgressHandle(String displayName) {
        this.initProgressHandle(displayName, -1);
    }

    public void updateProgressHandleAndTakeOwnership(String message, Object owner, int stepsIncrement) {
        this.progressHandleOwner = owner;
        this.updateProgressHandle(message, stepsIncrement);
    }

    public void updateProgressHandle(String message, int stepsIncrement) {
        if (this.progressHandle == null) {
            throw new IllegalStateException("No progress handle has been initialized");
        }
        if (!this.isProgressHandleActive()) {
            return;
        }
        if (stepsIncrement > 0) {
            this.progressHandle.progress(message, stepsIncrement);
        } else {
            this.progressHandle.progress(message);
        }
    }

    public void updateProgressHandle(String message) {
        this.updateProgressHandle(message, -1);
    }

    public void setProgressHandleDisplayName(String displayName) {
        if (this.progressHandle != null) {
            this.progressHandle.setDisplayName(displayName);
        }
    }

    public void finishProgressHandle() {
        if (this.progressHandle != null) {
            this.progressHandle.finish();
        }
        this.progressHandleActive = false;
    }

    public boolean isProgressHandleActive() {
        return this.progressHandleActive;
    }

    public boolean isRetargetableProcess() {
        return false;
    }

    public RunProcess getRetargetProcess(Context context, RunProcess formerProcess) {
        return null;
    }
}

