/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.model.Project;
import oracle.ide.model.SingletonProvider;
import oracle.ide.model.Workspace;
import oracle.ide.runner.DebuggerAdapter;
import oracle.ide.runner.DebuggerEventSource;
import oracle.ide.runner.DebuggerExtender;
import oracle.ide.runner.DebuggerExtenderCallback;
import oracle.ide.runner.DebuggerExtenderDeclarator;
import oracle.ide.runner.DebuggerInspectorExpressionProvider;
import oracle.ide.runner.DebuggerStartCallback;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.runner.DebuggerWindowProviderCallback;
import oracle.ide.runner.DebuggerWindowProviderDeclarator;
import oracle.ide.runner.SmartDataProvider;
import oracle.ide.runner.ToolTipExpressionProvider;
import oracle.ideimpl.runner.DebuggerHook;
import oracle.javatools.jndi.Names;

public abstract class Debugger {
    private static final String DEBUGGER_NAME = "ide/debugger";
    private static Debugger debugger;

    public static synchronized Debugger getDebugger() {
        if (debugger == null && (debugger = (Debugger)SingletonProvider.find(Debugger.class)) == null) {
            debugger = (Debugger)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)DEBUGGER_NAME);
        }
        return debugger;
    }

    @Deprecated
    public static synchronized void setDebugger(Debugger debugger) {
        Debugger.debugger = debugger;
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)DEBUGGER_NAME, (Object)debugger);
    }

    public abstract JMenu getDebugMenu();

    public abstract ContextMenu getContextMenu();

    @Deprecated
    public JMenu getViewMenu() {
        return null;
    }

    public abstract boolean isDebugging();

    public abstract void startDebugger(Context var1, DebuggerStartCallback var2);

    @Deprecated
    public abstract void redefineClasses(Map var1);

    public abstract void redefineClasses(Project var1, Map var2);

    public abstract boolean isStackTraceLine(String var1);

    public abstract boolean showSourceFileForStackTraceLine(Workspace var1, Project var2, String var3);

    public abstract URL parseStackTraceLine(Workspace var1, Project var2, String var3);

    public abstract boolean showSourceFileForStackTraceLine(Workspace var1, Project var2, URL var3);

    public final void addSmartDataProvider(SmartDataProvider smartDataProvider) {
        DebuggerHook.addSmartDataProvider(smartDataProvider);
    }

    public final void removeSmartDataProvider(SmartDataProvider smartDataProvider) {
        DebuggerHook.removeSmartDataProvider(smartDataProvider);
    }

    public final void addToolTipExpressionProvider(ToolTipExpressionProvider toolTipExpressionProvider) {
        DebuggerHook.addToolTipExpressionProvider(toolTipExpressionProvider);
    }

    public final void removeToolTipExpressionProvider(ToolTipExpressionProvider toolTipExpressionProvider) {
        DebuggerHook.removeToolTipExpressionProvider(toolTipExpressionProvider);
    }

    public abstract void addRunAndDebugToContextMenu(ContextMenu var1, Context var2);

    public final void addDebuggerListener(DebuggerAdapter debuggerListener) {
        DebuggerHook.addDebuggerListener(debuggerListener);
    }

    public final void removeDebuggerListener(DebuggerAdapter debuggerListener) {
        DebuggerHook.removeDebuggerListener(debuggerListener);
    }

    public abstract Object evaluateNumericExpression(String var1);

    @Deprecated
    public DebuggerWindowProviderCallback addDebuggerWindowProvider(DebuggerWindowProvider provider) {
        return null;
    }

    public void addDebuggerWindowProvider(DebuggerWindowProviderDeclarator declarator) {
    }

    public void removeDebuggerWindowProvider(DebuggerWindowProvider provider) {
    }

    @Deprecated
    public DebuggerExtenderCallback addDebuggerExtender(DebuggerExtender extender) {
        return null;
    }

    public void addDebuggerExtender(DebuggerExtenderDeclarator extenderDeclarator) {
    }

    public void addDebuggerExtender(DebuggerExtenderDeclarator extenderDeclarator, List<String> sourceExtensions) {
    }

    public void removeDebuggerExtender(DebuggerExtender extender) {
    }

    public final void addObjectPreferencesExpression(String className, String expression, boolean selected) {
        if (className != null && className.trim().length() > 0 && expression != null && expression.trim().length() > 0) {
            DebuggerHook.addExpression(className, expression, selected);
        }
    }

    public final void addObjectPreferencesExpansion(String className, String expressions, boolean selected) {
        if (className != null && className.trim().length() > 0 && expressions != null && expressions.trim().length() > 0) {
            DebuggerHook.addExpression(className, expressions, selected);
        }
    }

    public final void addObjectPreferencesHideAllFields(String className) {
        if (className != null && className.trim().length() > 0) {
            DebuggerHook.addHideAllFields(className);
        }
    }

    public final void addObjectPreferencesHideField(String className, String fieldName) {
        if (className != null && className.trim().length() > 0 && fieldName != null && fieldName.trim().length() > 0) {
            DebuggerHook.addHideField(className, fieldName);
        }
    }

    public final void addObjectPreferencesIcon(String className, String iconName) {
        if (className != null && className.length() > 0 && iconName != null && iconName.length() > 0) {
            DebuggerHook.addIcon(className, iconName);
        }
    }

    public final void addInspectorExpressionProvider(DebuggerInspectorExpressionProvider expressionProvider) {
        DebuggerHook.addInspectorExpressionProvider(expressionProvider);
    }

    public final void removeInspectorExpressionProvider(DebuggerInspectorExpressionProvider expressionProvider) {
        DebuggerHook.removeInspectorExpressionProvider(expressionProvider);
    }

    public abstract List<DebuggerEventSource> getDebuggerState();
}

