/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.apptemplate;

import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.util.MetaClass;
import oracle.jdeveloper.wizard.apptemplate.WizardDefaultsProvider;
import oracle.jdeveloper.wizard.apptemplate.WizardDefaultsProviderManager;

public class WizardDefaultsProviderHook
extends ExtensionHook {
    private static final ElementName HOOK_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "wizard-defaults-provider");
    private static final ElementName INCLUDE_ELEMENT_NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "include");

    public void start(ElementStartContext context) {
        String delegateClass = context.getAttributeValue("class");
        if (delegateClass == null) {
            context.getLogger().warning("'class' attribute is missing, ignoring hook registration of " + HOOK_NAME + " in extension " + context.getExtension().getID());
            return;
        }
        String technologyScope = context.getAttributeValue("technology-scope");
        if (technologyScope == null) {
            context.getLogger().warning("'technology-scope' attribute is missing in extension " + context.getExtension().getID());
            return;
        }
        context.registerChildVisitor(INCLUDE_ELEMENT_NAME, (ElementVisitor)new IncludeElementVisitor((MetaClass<? extends WizardDefaultsProvider>)new MetaClass(ElementVisitor.getClassLoader((ElementContext)context), delegateClass), technologyScope));
    }

    private static class IncludeElementVisitor
    extends ElementVisitor {
        private static final String KEY = "key";
        private static final String VALUE = "value";
        private static final String DELEGATE = "DELEGATE";
        private final MetaClass<? extends WizardDefaultsProvider> m_metaClass;
        private final String m_techScope;

        IncludeElementVisitor(MetaClass<? extends WizardDefaultsProvider> mc, String techScope) {
            this.m_metaClass = mc;
            this.m_techScope = techScope;
        }

        public void start(ElementStartContext context) {
            String key = context.getAttributeValue(KEY);
            if (key == null) {
                context.getLogger().warning("'key' attribute is missing");
                return;
            }
            String value = context.getAttributeValue(VALUE);
            if (value == null) {
                context.getLogger().warning("'value' attribute is missing");
                return;
            }
            boolean isDelegated = DELEGATE.equalsIgnoreCase(value);
            if (isDelegated) {
                WizardDefaultsProviderManager.getManager().registerDefaultsByDelegate(key, this.m_metaClass, this.m_techScope);
            } else {
                WizardDefaultsProviderManager.getManager().registerDefaultsByValue(key, value, this.m_techScope);
            }
        }
    }
}

