/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.apptemplate;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.I18NStringVisitor;
import oracle.ide.model.TechnologyScope;
import oracle.ide.util.Assert;
import oracle.jdeveloper.template.AbstractTemplate;
import oracle.jdeveloper.template.ApplicationTemplate;
import oracle.jdeveloper.template.DefaultTemplateData;
import oracle.jdeveloper.template.ProjectTemplate;
import oracle.jdeveloper.template.TemplateManager;
import oracle.jdeveloper.wizard.apptemplate.ApplicationData;
import oracle.jdeveloper.wizard.apptemplate.ProjectData;
import oracle.jdeveloper.wizard.apptemplate.TemplatesData;

@Deprecated
public final class ApplicationTemplateHookHandler
extends ExtensionHook {
    private static final String NS = "http://xmlns.oracle.com/jdeveloper/1013/jdev-application-templates";
    public static final ElementName ELEMENT = ApplicationTemplateHookHandler.element("application-templates-hook");
    private TemplatesData _templateData = new TemplatesData();
    private Map _techkeyMap = new HashMap();
    private static String KEY_ROOT_TEMPLATE_DATA = "root-template-data";
    private static String KEY_APPLICATION_DATA = "application-data";
    private static String KEY_PROJECT_DATA = "project-data";
    private static String KEY_PROJECT_LIST = "project-list";
    private static String KEY_TECHNOLOGY_SCOPE = "technology-scope";
    private static String KEY_TECHKEY_MAP = "technology-key-map";
    private final ElementVisitor _applicationDataHandler = new ApplicationDataHandler();
    private final ElementVisitor _nameHandler = new NameHandler();
    private final ElementVisitor _namePrjHandler = new NamePrjHandler();
    private final ElementVisitor _descriptionHandler = new DescriptionHandler();
    private final ElementVisitor _weightHandler = new WeightHandler();
    private final ElementVisitor _projectDataHandler = new ProjectDataHandler();
    private final ElementVisitor _packageNameHandler = new PackageNameHandler();
    private final ElementVisitor _projectNameHandler = new ProjectNameHandler();
    private final ElementVisitor _promptForProjectNameHandler = new PromptForProjectNameHandler();
    private final ElementVisitor _technologyScopeHandler = new TechnologyScopeHandler();
    DefaultTemplateData _bridgeTemplateData = new DefaultTemplateData((URL)null);
    Map<ProjectTemplate, List> _bridgeTechKeyMap = new HashMap<ProjectTemplate, List>();
    private static String BRIDGE_ROOT_TEMPLATE_DATA = "root-bridge-template-data";
    private static String BRIDGE_APPLICATION_TEMPLATE = "application-template";
    private static String BRIDGE_TECHKEY_MAP = "bridge-technology-key-map";

    private static final ElementName element(String name) {
        return new ElementName(NS, name);
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(ApplicationTemplateHookHandler.element("application-data"), this._applicationDataHandler);
        context.getScopeData().put(KEY_ROOT_TEMPLATE_DATA, this._templateData);
        context.getScopeData().put(KEY_TECHKEY_MAP, this._techkeyMap);
        context.getScopeData().put(BRIDGE_ROOT_TEMPLATE_DATA, this._bridgeTemplateData);
        context.getScopeData().put(BRIDGE_TECHKEY_MAP, this._bridgeTechKeyMap);
    }

    TemplatesData getTemplatesData() {
        this.assignTechnologyScope();
        return this._templateData;
    }

    public void registerTemplates(TemplateManager mgr) {
        for (ProjectTemplate projectTemplate : this._bridgeTemplateData.getTemplateByClass(ProjectTemplate.class)) {
            List keyList = this._bridgeTechKeyMap.get(projectTemplate);
            if (keyList != null) {
                TechnologyScope ts = new TechnologyScope();
                ts.setTechnologyKeys(keyList.toArray(new String[keyList.size()]));
                projectTemplate.setTechnologyScope(ts);
            }
            this.registerIfNotDuplicate(mgr, projectTemplate);
        }
        for (AbstractTemplate abstractTemplate : this._bridgeTemplateData.getTemplateByClass(ApplicationTemplate.class)) {
            this.registerIfNotDuplicate(mgr, abstractTemplate);
        }
    }

    private void registerIfNotDuplicate(TemplateManager mgr, AbstractTemplate t) {
        if (mgr.getDefaultTemplateData().getTemplateById(t.getTemplateId()) == null) {
            mgr.registerTemplate(t);
        } else {
            mgr.getLogger().warning("Duplicate template id " + t.getTemplateId());
            Assert.printStackTrace((boolean)true, (String)("Duplicate template id " + t.getTemplateId()));
        }
    }

    private void assignTechnologyScope() {
        for (ProjectData pd : this._techkeyMap.keySet()) {
            List keyList = (List)this._techkeyMap.get(pd);
            TechnologyScope ts = new TechnologyScope();
            String[] keysArray = new String[keyList.size()];
            keyList.toArray(keysArray);
            ts.setTechnologyKeys(keysArray);
            pd.setTechnologyScope(ts);
        }
    }

    private Map getTechnologyKeyMap(ElementContext context) {
        return (Map)context.getScopeData().get(KEY_TECHKEY_MAP);
    }

    private ApplicationData getApplication(ElementContext context) {
        return (ApplicationData)context.getScopeData().get(KEY_APPLICATION_DATA);
    }

    private ProjectData getProjectData(ElementContext context) {
        return (ProjectData)context.getScopeData().get(KEY_PROJECT_DATA);
    }

    private class TechnologyKeyHandler
    extends ElementVisitor {
        private TechnologyKeyHandler() {
        }

        public void end(ElementEndContext context) {
            List keyList = (List)context.getScopeData().get(KEY_TECHNOLOGY_SCOPE);
            keyList.add(context.getText().trim());
        }
    }

    private class TechnologyScopeHandler
    extends ElementVisitor {
        private ElementVisitor _technologyKeyHandler;

        private TechnologyScopeHandler() {
            this._technologyKeyHandler = new TechnologyKeyHandler();
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(ApplicationTemplateHookHandler.element("technologyKey"), this._technologyKeyHandler);
            context.getScopeData().put(KEY_TECHNOLOGY_SCOPE, new ArrayList());
        }

        public void end(ElementEndContext context) {
            List keyList = (List)context.getScopeData().get(KEY_TECHNOLOGY_SCOPE);
            ProjectData pd = ApplicationTemplateHookHandler.this.getProjectData((ElementContext)context);
            Map techMap = ApplicationTemplateHookHandler.this.getTechnologyKeyMap((ElementContext)context);
            techMap.put(pd, keyList);
        }
    }

    private class PromptForProjectNameHandler
    extends I18NStringVisitor {
        private PromptForProjectNameHandler() {
        }

        protected void string(ElementContext context, String string) {
            boolean promptForName = false;
            if (string.equalsIgnoreCase("true")) {
                promptForName = true;
            }
            ApplicationTemplateHookHandler.this.getProjectData(context).setPromptForProjectName(promptForName);
        }
    }

    private class ProjectNameHandler
    extends I18NStringVisitor {
        private ProjectNameHandler() {
        }

        protected void string(ElementContext context, String string) {
            ApplicationTemplateHookHandler.this.getProjectData(context).setProjectName(string);
        }
    }

    private class PackageNameHandler
    extends I18NStringVisitor {
        private PackageNameHandler() {
        }

        protected void string(ElementContext context, String string) {
            ApplicationTemplateHookHandler.this.getProjectData(context).setPackageName(string);
        }
    }

    private class NamePrjHandler
    extends I18NStringVisitor {
        private NamePrjHandler() {
        }

        protected void string(ElementContext context, String translatedString) {
            ProjectData pd = ApplicationTemplateHookHandler.this.getProjectData(context);
            pd.setName(translatedString);
        }
    }

    private class ProjectDataHandler
    extends ElementVisitor {
        private ProjectDataHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(ApplicationTemplateHookHandler.element("name"), ApplicationTemplateHookHandler.this._namePrjHandler);
            context.registerChildVisitor(ApplicationTemplateHookHandler.element("packageName"), ApplicationTemplateHookHandler.this._packageNameHandler);
            context.registerChildVisitor(ApplicationTemplateHookHandler.element("projectName"), ApplicationTemplateHookHandler.this._projectNameHandler);
            context.registerChildVisitor(ApplicationTemplateHookHandler.element("promptForProjectName"), ApplicationTemplateHookHandler.this._promptForProjectNameHandler);
            context.registerChildVisitor(ApplicationTemplateHookHandler.element("technologyScope"), ApplicationTemplateHookHandler.this._technologyScopeHandler);
            context.getScopeData().put(KEY_PROJECT_DATA, new ProjectData());
        }

        public void end(ElementEndContext context) {
            List projects = (List)context.getScopeData().get(KEY_PROJECT_LIST);
            projects.add(ApplicationTemplateHookHandler.this.getProjectData((ElementContext)context));
            ProjectData pd = ApplicationTemplateHookHandler.this.getProjectData((ElementContext)context);
            ProjectTemplate pt = new ProjectTemplate();
            pt.setName(pd.getName());
            pt.setContainerName(pd.getProjectName());
            pt.setPackageName(pd.getPackageName());
            List keyList = (List)ApplicationTemplateHookHandler.this.getTechnologyKeyMap((ElementContext)context).get(pd);
            pt.setTemplateId(this.generateId(pd, keyList));
            if (keyList != null && keyList.size() > 0) {
                Map techKeyMap = (Map)context.getScopeData().get(BRIDGE_TECHKEY_MAP);
                techKeyMap.put(pt, keyList);
            }
            DefaultTemplateData templateData = (DefaultTemplateData)context.getScopeData().get(BRIDGE_ROOT_TEMPLATE_DATA);
            ApplicationTemplate appTemplate = (ApplicationTemplate)context.getScopeData().get(BRIDGE_APPLICATION_TEMPLATE);
            templateData.addTemplate(pt);
            appTemplate.addProjectTemplate(pt);
        }

        private String generateId(ProjectData template, List techScopes) {
            Collections.sort(techScopes, String.CASE_INSENSITIVE_ORDER);
            StringBuffer buffer = new StringBuffer();
            buffer.append('#');
            buffer.append(template.getName());
            for (Object tech : techScopes) {
                buffer.append('_');
                buffer.append(tech.toString());
            }
            return buffer.toString();
        }
    }

    private class WeightHandler
    extends I18NStringVisitor {
        private WeightHandler() {
        }

        protected void string(ElementContext context, String string) {
            ApplicationData ad = ApplicationTemplateHookHandler.this.getApplication(context);
            try {
                ad.setWeight(Float.valueOf(string).floatValue());
            }
            catch (NumberFormatException ex) {
                ad.setWeight(0.0f);
            }
        }
    }

    private class DescriptionHandler
    extends I18NStringVisitor {
        private DescriptionHandler() {
        }

        protected void string(ElementContext context, String translatedString) {
            ApplicationData ad = ApplicationTemplateHookHandler.this.getApplication(context);
            ad.setDescription(translatedString);
        }
    }

    private class NameHandler
    extends I18NStringVisitor {
        private NameHandler() {
        }

        protected void string(ElementContext context, String translatedString) {
            ApplicationData ad = ApplicationTemplateHookHandler.this.getApplication(context);
            ad.setName(translatedString);
        }
    }

    private class ApplicationDataHandler
    extends ElementVisitor {
        private ApplicationDataHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(ApplicationTemplateHookHandler.element("name"), ApplicationTemplateHookHandler.this._nameHandler);
            context.registerChildVisitor(ApplicationTemplateHookHandler.element("description"), ApplicationTemplateHookHandler.this._descriptionHandler);
            context.registerChildVisitor(ApplicationTemplateHookHandler.element("weight"), ApplicationTemplateHookHandler.this._weightHandler);
            context.registerChildVisitor(ApplicationTemplateHookHandler.element("projectData"), ApplicationTemplateHookHandler.this._projectDataHandler);
            context.getScopeData().put(KEY_APPLICATION_DATA, new ApplicationData());
            context.getScopeData().put(KEY_PROJECT_LIST, new ArrayList());
            context.getScopeData().put(BRIDGE_APPLICATION_TEMPLATE, new ApplicationTemplate());
        }

        public void end(ElementEndContext context) {
            TemplatesData td = (TemplatesData)context.getScopeData().get(KEY_ROOT_TEMPLATE_DATA);
            List projects = (List)context.getScopeData().get(KEY_PROJECT_LIST);
            ProjectData[] pd = new ProjectData[projects.size()];
            projects.toArray(pd);
            ApplicationTemplateHookHandler.this.getApplication((ElementContext)context).setProjectData(pd);
            ApplicationTemplateHookHandler.this.getApplication((ElementContext)context).setMaster(td);
            td.add(ApplicationTemplateHookHandler.this.getApplication((ElementContext)context));
            ApplicationData ad = ApplicationTemplateHookHandler.this.getApplication((ElementContext)context);
            ApplicationTemplate at = (ApplicationTemplate)context.getScopeData().get(BRIDGE_APPLICATION_TEMPLATE);
            at.setName(ad.getName());
            at.setTemplateId("#" + ad.getName());
            at.setDescription(ad.getDescription());
            at.setWeight(ad.getWeight());
            DefaultTemplateData dtd = (DefaultTemplateData)context.getScopeData().get(BRIDGE_ROOT_TEMPLATE_DATA);
            dtd.addTemplate(at);
        }
    }
}

