/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.template;

import java.net.URL;
import java.util.logging.Level;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.template.DefaultTemplateData;
import oracle.jdeveloper.template.TemplateData;
import oracle.jdeveloper.template.TemplateManager;
import oracle.jdeveloper.template.TemplateManagerImpl;

public class TemplateUtils {
    public static void logTemplateCreationException(HashStructure hash, Throwable e) {
        String msg = "Could not create template from hash";
        TemplateManager.getInstance().getLogger().log(Level.WARNING, "Could not create template from hash", e);
    }

    public static boolean isDefaultTemplateData(TemplateData td) {
        return TemplateManagerImpl.getDefaultTemplateDataURL().toString().equals(td.getURL().toString());
    }

    public static boolean isUserTemplateData(TemplateData td) {
        return TemplateManagerImpl.getUserTemplateDataURL().toString().equals(td.getURL().toString());
    }

    public static DefaultTemplateData createUserTemplateData() {
        return new DefaultTemplateData(TemplateManagerImpl.getUserTemplateDataURL());
    }

    public static URL dir2TemplateDataFile(URL dirURL) {
        URL baseURL = null;
        baseURL = URLFileSystem.isDirectoryPath((URL)dirURL) ? dirURL : URLFileSystem.getParent((URL)dirURL);
        if (baseURL == null) {
            throw new IllegalArgumentException("Base URL could not be determined : " + dirURL);
        }
        return URLFactory.newURL((URL)dirURL, (String)"template-data.xml");
    }
}

