/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.template;

import java.awt.Component;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.template.AddonPage;

public final class AddonPageTemplate {
    private static final String TEMPLATE_ADDON_PAGE_GROUP = "addonPageGroup";
    private static final String TEMPLATE_PAGEID = "pageId";
    private static final String TEMPLATE_LOCATION = "location";
    private static final String TEMPLATE_LABEL = "label";
    private static final String TEMPLATE_TITLE = "title";
    private static final String TEMPLATE_CLASS = "class";
    private HashStructure _hash;

    public AddonPageTemplate(HashStructure hash) {
        this._hash = hash;
    }

    public PageLocation getLocation() {
        String value;
        PageLocation result = PageLocation.DEFAULT;
        if (this._hash.containsKey(TEMPLATE_LOCATION) && (value = this.getTextFromHook(this._hash, TEMPLATE_LOCATION).toLowerCase()) != null) {
            for (PageLocation item : PageLocation.values()) {
                String name = item.toString().toLowerCase();
                if (!value.equals(name)) continue;
                result = item;
                break;
            }
        }
        return result;
    }

    public String getPageId() {
        return this.getTextFromHook(this._hash, TEMPLATE_PAGEID);
    }

    public String getLabel() {
        return this.getTextFromHook(this._hash, TEMPLATE_LABEL);
    }

    public String getTitle() {
        return this.getTextFromHook(this._hash, TEMPLATE_TITLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component createPage() {
        Component result = null;
        String clazz = this.getTextFromHook(this._hash, TEMPLATE_CLASS);
        if (ModelUtil.hasLength((String)clazz)) {
            ReflectiveOperationException throwable = null;
            try {
                String extensionId = this._hash.getString("#__extension-id");
                ClassLoader classLoader = ExtensionRegistry.getExtensionRegistry().getClassLoader(extensionId);
                MetaClass metaClass = new MetaClass(classLoader, clazz);
                result = (Component)metaClass.newInstance();
                if (result instanceof AddonPage) {
                    ((AddonPage)((Object)result)).setAddonGroup(this.getAddonPageGroup());
                }
            }
            catch (InstantiationException e) {
                throwable = e;
            }
            catch (IllegalAccessException e) {
                throwable = e;
            }
            catch (ClassNotFoundException e) {
                throwable = e;
            }
            finally {
                if (throwable != null) {
                    throwable.printStackTrace();
                }
            }
        }
        return result;
    }

    public String getAddonPageGroup() {
        return this.getTextFromHook(this._hash, TEMPLATE_ADDON_PAGE_GROUP);
    }

    private String getTextFromHook(HashStructure hash, String key) {
        String result = null;
        if (hash.containsKey(key)) {
            result = hash.getString(key + "/#text");
        }
        return result;
    }

    public static enum PageLocation {
        DEFAULT,
        BEGINNING,
        END;

    }
}

