/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.server;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.XANative;

public class OracleXAResource
extends oracle.jdbc.xa.OracleXAResource {
    private int[] appVal = new int[]{0};
    protected static boolean _DEBUG = false;

    public OracleXAResource() {
        try {
            this.connection = new OracleDriver().defaultConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void finalize() {
    }

    public void start(Xid xid, int flag) throws XAException {
        int returnVal = 0;
        int formatId = xid.getFormatId();
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        if (_DEBUG) {
            System.out.println("OracleXAResource.start ():start");
        }
        if (gtrid == null && bqual == null) {
            gtrid = new byte[1];
            bqual = new byte[1];
        }
        if (_DEBUG) {
            System.out.println("OracleXAResource.start (): gtrid = " + gtrid.length + " " + gtrid[gtrid.length - 1] + " bqual = " + bqual.length + " " + bqual[bqual.length - 1]);
        }
        if (flag != 0 && flag != 0x8000000 && flag != 0x200000 && (flag & 2) != 2) {
            System.out.println("OracleXAResource.start (): XAER_INVAL; invalid flag");
            throw new OracleXAException(-5);
        }
        returnVal = XANative.start(formatId, gtrid, bqual, flag, (short)this.timeout);
        this.checkError(returnVal);
        boolean[] isLocallySuspended = new boolean[]{false};
        super.createOrUpdateXid(xid, false, isLocallySuspended);
        if (_DEBUG) {
            System.out.println("OracleXAResource.start ():end");
        }
    }

    public void end(Xid xid, int flag) throws XAException {
        int returnVal = 0;
        int formatId = xid.getFormatId();
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        boolean needToResume = false;
        if (_DEBUG) {
            System.out.println("OracleXAResource.end(xid, int):start");
        }
        if (_DEBUG) {
            System.out.println("OracleXAResource.end(): gtrid = " + gtrid.length + " " + gtrid[gtrid.length - 1] + " bqual = " + bqual.length + " " + bqual[bqual.length - 1]);
        }
        if (gtrid == null && bqual == null) {
            gtrid = new byte[1];
            bqual = new byte[1];
        }
        boolean currentXidSuspended = this.isXidSuspended(xid);
        Xid stackedXid = super.suspendStacked(xid);
        boolean[] flags = new boolean[]{false, false};
        boolean foundXid = true;
        if (flag == 0x2000000) {
            super.createOrUpdateXid(xid, true, flags);
        } else if (stackedXid != null) {
            foundXid = super.updateXidList(xid, flags);
            needToResume = flags[1];
        }
        if (!needToResume) {
            if (!foundXid && flag == 0x4000000) {
                needToResume = true;
            } else if (currentXidSuspended) {
                needToResume = true;
            }
        }
        if (needToResume && (returnVal = XANative.start(formatId, gtrid, bqual, 0x8000000, (short)this.timeout)) != 0) {
            super.resumeStacked(stackedXid);
            this.checkError(returnVal);
        }
        returnVal = XANative.end(formatId, gtrid, bqual, flag, (short)0);
        if (flag == 0x4000000 && returnVal == 0) {
            this.removeXidFromList(xid);
            this.activeXid = null;
        }
        if (stackedXid != null) {
            super.resumeStacked(stackedXid);
        } else if (this.isXidListEmpty()) {
            this.exitGlobalTxnMode();
            this.activeXid = null;
        }
        this.checkError(returnVal);
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (_DEBUG) {
            System.out.println("OracleXAResource.commit(xid, bool):start");
        }
        int returnVal = 0;
        int formatId = xid.getFormatId();
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        int flag = 0;
        if (_DEBUG) {
            System.out.println("OracleXAResource.commit (): gtrid = " + gtrid.length + " " + gtrid[gtrid.length - 1] + " bqual = " + bqual.length + " " + bqual[bqual.length - 1]);
        }
        if (gtrid == null && bqual == null) {
            gtrid = new byte[1];
            bqual = new byte[1];
        }
        flag = onePhase ? 0x40000000 : 0;
        Xid stackedXid = super.suspendStacked(xid);
        returnVal = XANative.commit(formatId, gtrid, bqual, flag, (short)0);
        super.resumeStacked(stackedXid);
        this.checkError(returnVal);
        if (_DEBUG) {
            System.out.println("OracleXAResource.commit (xid, bool):end");
        }
    }

    public int prepare(Xid xid) throws XAException {
        int returnVal = 0;
        int formatId = xid.getFormatId();
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        if (_DEBUG) {
            System.out.println("OracleXAResource.prepare():start");
        }
        if (gtrid == null && bqual == null) {
            throw new OracleXAException(-4);
        }
        Xid stackedXid = super.suspendStacked(xid);
        returnVal = XANative.prepare(formatId, gtrid, bqual, (short)0);
        super.resumeStacked(stackedXid);
        if ((returnVal & 0xFFFF) != 0 && (returnVal & 0xFFFF) != 3) {
            throw new OracleXAException(returnVal);
        }
        return returnVal;
    }

    public void forget(Xid xid) throws XAException {
        int returnVal = 0;
        int formatId = xid.getFormatId();
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        if (gtrid == null && bqual == null) {
            throw new OracleXAException(-4);
        }
        returnVal = XANative.forget(formatId, gtrid, bqual, (short)0);
        this.checkError(returnVal);
    }

    public void rollback(Xid xid) throws XAException {
        int returnVal = 0;
        int formatId = xid.getFormatId();
        byte[] gtrid = xid.getGlobalTransactionId();
        byte[] bqual = xid.getBranchQualifier();
        if (gtrid == null && bqual == null) {
            gtrid = new byte[1];
            bqual = new byte[1];
        }
        Xid stackedXid = super.suspendStacked(xid);
        returnVal = XANative.rollback(formatId, gtrid, bqual, (short)0);
        super.resumeStacked(stackedXid);
        this.checkError(returnVal);
    }

    private Connection getDefaultConnection() {
        if (this.connection != null) {
            return this.connection;
        }
        try {
            this.connection = new OracleDriver().defaultConnection();
            return this.connection;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void suspend(Xid xid) throws XAException {
        this.end(xid, 0x2000002);
    }
}

