/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import oracle.jdbc.xa.server.OracleWrapXAResource;

public class OracleMultiPhaseArgsJavavm {
    int action = 0;
    int nsites = 0;
    Vector dbLinks = null;
    Vector xids = null;
    public static boolean JTAdebug = true;

    public OracleMultiPhaseArgsJavavm() {
    }

    public OracleMultiPhaseArgsJavavm(int _action, int _nsites, Vector _xids, Vector _dbLinks) {
        if (_nsites <= 1) {
            this.action = 0;
            this.nsites = 0;
            this.dbLinks = null;
            this.xids = null;
            if (JTAdebug) {
                System.out.println("number of sites is <= ONE!!...");
            }
        } else if (_xids.isEmpty() || _dbLinks.isEmpty() || _dbLinks.size() != _nsites || _xids.size() != 3 * _nsites) {
            if (JTAdebug) {
                System.out.println("some parameter is wrong...");
            }
        } else {
            this.action = _action;
            this.nsites = _nsites;
            this.xids = _xids;
            this.dbLinks = _dbLinks;
        }
    }

    public OracleMultiPhaseArgsJavavm(byte[] inBytes) {
        if (JTAdebug) {
            System.out.println("OMPA (byte[]): begin");
            System.out.println("  inBytes.length = " + inBytes.length);
        }
        ByteArrayInputStream byteArrayIS = new ByteArrayInputStream(inBytes);
        DataInputStream dataIS = new DataInputStream(byteArrayIS);
        this.xids = new Vector();
        this.dbLinks = new Vector();
        try {
            this.action = dataIS.readInt();
            this.nsites = dataIS.readInt();
            int fmtid = dataIS.readInt();
            int gtridLen = dataIS.readInt();
            byte[] gtrid = new byte[gtridLen];
            int gtridRead = dataIS.read(gtrid, 0, gtridLen);
            for (int i = 0; i < this.nsites; ++i) {
                int bqualLen = dataIS.readInt();
                byte[] bqual = new byte[bqualLen];
                int bqualRead = dataIS.read(bqual, 0, bqualLen);
                this.xids.addElement(new Integer(fmtid));
                this.xids.addElement(gtrid);
                this.xids.addElement(bqual);
                String dblink = dataIS.readUTF();
                this.dbLinks.addElement(dblink);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (JTAdebug) {
            System.out.println("OMPA (byte[]): end");
        }
    }

    public byte[] toByteArray() {
        return this.toByteArrayOS().toByteArray();
    }

    public ByteArrayOutputStream toByteArrayOS() {
        byte[] gtridCommon = null;
        int fmtidCommon = 0;
        if (JTAdebug) {
            System.out.println("OMPA.toByteArrayOS (): begin");
        }
        ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
        DataOutputStream dataOS = new DataOutputStream(byteArrayOS);
        try {
            dataOS.writeInt(this.action);
            dataOS.writeInt(this.nsites);
            for (int i = 0; i < this.nsites; ++i) {
                String dblink = (String)this.dbLinks.elementAt(i);
                int fmtid = (Integer)this.xids.elementAt(i * 3);
                byte[] gtrid = (byte[])this.xids.elementAt(i * 3 + 1);
                byte[] bqual = (byte[])this.xids.elementAt(i * 3 + 2);
                if (i == 0) {
                    fmtidCommon = fmtid;
                    gtridCommon = gtrid;
                    dataOS.writeInt(fmtid);
                    dataOS.writeInt(gtrid.length);
                    dataOS.write(gtrid, 0, gtrid.length);
                }
                dataOS.writeInt(bqual.length);
                dataOS.write(bqual, 0, bqual.length);
                dataOS.writeUTF(dblink);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (JTAdebug) {
            System.out.println("OMPA.toByteArrayOS (): end");
        }
        return byteArrayOS;
    }

    public int getAction() {
        return this.action;
    }

    public int getnsite() {
        return this.nsites;
    }

    public Vector getdbLinks() {
        return this.dbLinks;
    }

    public Vector getXids() {
        return this.xids;
    }

    public void printMPArgs() {
        System.out.println("  action = " + this.action);
        System.out.println("  nsites = " + this.nsites);
        for (int i = 0; i < this.nsites; ++i) {
            String dblink = (String)this.dbLinks.elementAt(i);
            int fmtid = (Integer)this.xids.elementAt(i * 3);
            byte[] gtrid = (byte[])this.xids.elementAt(i * 3 + 1);
            byte[] bqual = (byte[])this.xids.elementAt(i * 3 + 2);
            System.out.println("  fmtid  [" + i + "] = " + fmtid);
            System.out.print("  gtrid  [" + i + "] = ");
            this.printByteArray(gtrid);
            System.out.print("  bqual  [" + i + "] = ");
            this.printByteArray(bqual);
            System.out.println("  dblink [" + i + "] = " + dblink);
        }
    }

    private void printByteArray(byte[] bArray) {
        for (int i = 0; i < bArray.length; ++i) {
            System.out.print(bArray[i] + " ");
        }
        System.out.println();
    }

    public static void setJTADebug(boolean b) {
        JTAdebug = b;
        OracleWrapXAResource.setJTADebug(b);
    }
}

