/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.tools;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import oracle.aurora.util.tools.AbortException;
import oracle.aurora.util.tools.JdbcOptions;
import oracle.aurora.util.tools.ToolError;
import oracle.aurora.util.tools.ToolException;
import oracle.aurora.util.tools.ToolLog;

public class Jdbc {
    private JdbcOptions opts;
    private Connection conn;
    private ToolLog log;

    public Jdbc(JdbcOptions opts, ToolLog log) {
        this(null, opts, log);
    }

    public Jdbc(Connection conn, JdbcOptions opts, ToolLog log) {
        this.conn = conn;
    }

    JdbcOptions getOpts() {
        if (this.opts == null) {
            this.opts = new JdbcOptions();
        }
        return this.opts;
    }

    ToolLog getLog() {
        if (this.log == null) {
            this.log = new ToolLog();
        }
        return this.log;
    }

    Connection getConnection() {
        if (this.conn == null) {
            try {
                this.conn = this.getOpts().getConnection();
            }
            catch (SQLException ex) {
                throw new AbortException(ex, "opening jdbc connection");
            }
            catch (ToolException ex) {
                throw new AbortException(ex, "opening jdbc connection");
            }
        }
        return this.conn;
    }

    void err(String msg) {
        this.getLog().err(msg);
    }

    void err(SQLException ex, String msg) {
        this.getLog().err(ex, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tableExists(String table) {
        boolean exists;
        block6: {
            exists = false;
            Connection conn = this.getConnection();
            Statement stmt = null;
            String when = "testing for existence of " + table;
            try {
                try {
                    stmt = conn.createStatement();
                    stmt.execute("select * from " + table);
                    exists = true;
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
            catch (SQLException sqlex) {
                if (Jdbc.checkCode(sqlex, 942)) break block6;
                this.getLog().err(sqlex, when);
            }
        }
        return exists;
    }

    public static boolean checkCode(Throwable ex, int code) {
        boolean c = ex instanceof SQLException ? Jdbc.checkCode((SQLException)ex, code) : (ex instanceof ToolException ? Jdbc.checkCode(((ToolException)ex).getChain(), code) : (ex instanceof ToolError ? Jdbc.checkCode(((ToolError)ex).getChain(), code) : false));
        return c;
    }

    public static boolean checkCode(SQLException ex, int code) {
        int count;
        boolean result = false;
        boolean found = false;
        SQLException next = ex;
        for (count = 0; next != null && !found && count < 100; ++count) {
            found = ex.getErrorCode() == code || Jdbc.checkCode(ex.getMessage(), code);
            next = ex.getNextException();
        }
        if (count > 100) {
            System.out.println("loop in SQLException next chain");
            SQLException s = ex;
            for (int x = 0; x < 100 && s != null; s = s.getNextException(), ++x) {
                System.out.println("    " + s);
            }
        }
        return found;
    }

    static boolean checkCode(String msg, int code) {
        String pat = "ORA-" + new DecimalFormat("00000").format(code);
        boolean found = msg != null && msg.indexOf(pat) >= 0;
        return found;
    }

    static boolean isUserInterrupt(SQLException sex) {
        return Jdbc.checkCode(sex, 1013);
    }

    static boolean isLostConnection(SQLException sex) {
        return Jdbc.checkCode(sex, 3113) || Jdbc.checkCode(sex, 3114) || sex.getErrorCode() == 0;
    }
}

