/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util.classfile;

import oracle.aurora.notinserver.FileLnkdFinder;
import oracle.aurora.util.classfile.Descriptor;
import oracle.aurora.util.classfile.Lnkd;
import oracle.aurora.util.classfile.Type;
import sun.tools.java.ClassPath;

public class TypeFactory {
    Lnkd[] aInterfaces;
    Lnkd java_lang_object;
    Lnkd.Finder finder;
    Type _errorType;

    public TypeFactory(Lnkd.Finder finder) {
        this.finder = finder;
    }

    public TypeFactory() {
        this.finder = Lnkd.nullFinder();
    }

    public Type construct(String descriptor) {
        Type t;
        Descriptor d = new Descriptor(descriptor);
        if (d.parseError()) {
            ClassFormatError err = new ClassFormatError("bad descriptor: " + descriptor);
            t = new Type.TypeError(err);
        } else if (d.isMethod()) {
            Type returnType = this.construct(d.getReturnType(), this.finder);
            Descriptor.Type[] dParams = d.getArgs();
            Type[] params = new Type[dParams.length];
            for (int xParam = 0; xParam < params.length; ++xParam) {
                params[xParam] = this.construct(dParams[xParam], this.finder);
            }
            t = new Type.Method(params, returnType);
        } else {
            t = this.construct(d.getFieldType(), this.finder);
        }
        return t;
    }

    public Type construct(Descriptor.Type dType, Lnkd.Finder finder) {
        Lnkd link;
        Type e = dType.isClass() ? ((link = finder.find(dType.name())) != null ? new Type.User(link) : new Type.UnboundUser(dType.name())) : new Type.Primitive(dType.getElementCode());
        Type t = dType.isArray() ? new Type.Array(dType.arrayCount, e, this) : e;
        return t;
    }

    public Type errorType(String why) {
        return new Type.TypeError(new VerifyError(why));
    }

    public Type unboundType(String name) {
        return new Type.UnboundUser(name);
    }

    public synchronized Lnkd arraySuper() {
        if (this.java_lang_object == null) {
            this.java_lang_object = this.finder.find("java/lang/Object");
        }
        return this.java_lang_object;
    }

    public synchronized Lnkd[] arrayInterfaces() {
        if (this.aInterfaces == null) {
            this.aInterfaces = new Lnkd[]{this.finder.find("java/lang/Cloneable"), this.finder.find("java/io/Serializable")};
        }
        return this.aInterfaces;
    }

    public static void main(String[] argv) {
        FileLnkdFinder finder = new FileLnkdFinder(new ClassPath(argv[0]));
        TypeFactory factory = new TypeFactory(finder);
        Type t = factory.construct(argv[1]);
        System.out.println(t.declaration("<name>"));
        System.out.println("getKind     " + t.getKind());
        System.out.println("isSimple    " + t.isSimple());
        System.out.println("isPrimitive " + t.isPrimitive());
        System.out.println("isArray     " + t.isArray());
        System.out.println("isObject    " + t.isObject());
        System.out.println("isMethod    " + t.isMethod());
        Lnkd[] interfaces = t.interfaces();
        int interfaceLen = interfaces == null ? 0 : interfaces.length;
        System.out.println("interfaces  " + interfaceLen);
        for (int xInterface = 0; xInterface < interfaceLen; ++xInterface) {
            System.out.println("            " + interfaces[xInterface]);
        }
        System.out.println("superClass  " + t.superClass());
        System.out.println("elem        " + t.elem());
        System.out.println("dim         " + t.dim());
        System.out.println("returnType  " + t.returnType());
        Type[] params = t.params();
        int paramLen = params == null ? 0 : params.length;
        System.out.println("params      " + paramLen);
        for (int xParam = 0; xParam < paramLen; ++xParam) {
            System.out.println("            " + params[xParam]);
        }
        Type copy = factory.construct(argv[1]);
        Type iType = factory.construct("I");
        System.out.println("hashCode      " + (t.hashCode() == copy.hashCode()));
        System.out.println("equals        " + t.equals(copy));
        System.out.println("! equals int  " + !t.equals(iType));
    }
}

