/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

public class OS {
    public static final int UNINITIALIZED = -1;
    public static final int UNKNOWN = 0;
    public static final int JAVAOS = 1;
    public static final int SUNOS = 2;
    public static final int WIN95 = 3;
    public static final int WINNT = 4;
    public static final int MACOS = 5;
    public static final int LINUX = 6;
    static int os = -1;
    static String osName = "";

    public static int getOS() {
        if (os == -1) {
            OS.reset();
        }
        return os;
    }

    public static String getOSName() {
        if (os == -1) {
            OS.reset();
        }
        return osName;
    }

    public static boolean isJavaOS() {
        if (os == -1) {
            OS.reset();
        }
        return os == 1;
    }

    public static boolean isLinux() {
        if (os == -1) {
            OS.reset();
        }
        return os == 6;
    }

    public static boolean isMacOS() {
        if (os == -1) {
            OS.reset();
        }
        return os == 5;
    }

    public static boolean isSunOS() {
        if (os == -1) {
            OS.reset();
        }
        return os == 2;
    }

    public static boolean isUnix() {
        if (os == -1) {
            OS.reset();
        } else if (os == 3 || os == 4 || os == 5) {
            return false;
        }
        return true;
    }

    public static boolean isWin95() {
        if (os == -1) {
            OS.reset();
        }
        return os == 3;
    }

    public static boolean isWindows() {
        if (os == -1) {
            OS.reset();
        }
        return os == 3 || os == 4;
    }

    public static boolean isWinNT() {
        if (os == -1) {
            OS.reset();
        }
        return os == 4;
    }

    public static void reset() {
        try {
            osName = System.getProperty("os.name", "Unknown");
        }
        catch (SecurityException e) {
            os = 0;
        }
        if (osName.equalsIgnoreCase("JavaOS")) {
            os = 1;
        } else if (osName.equalsIgnoreCase("Solaris")) {
            os = 2;
            osName = "SunOS";
        } else {
            os = osName.equalsIgnoreCase("SunOS") ? 2 : (osName.equalsIgnoreCase("Windows 95") ? 3 : (osName.equalsIgnoreCase("Windows NT") ? 4 : (osName.equalsIgnoreCase("MacOS") ? 5 : (osName.equalsIgnoreCase("Linux") ? 6 : 0))));
        }
    }
}

