/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import oracle.aurora.util.LocalStringManager;
import oracle.aurora.util.Tracer;

public class LocalStringManagerImpl
implements LocalStringManager {
    private Class defaultClass;
    private static Tracer tracer;

    public LocalStringManagerImpl(Class defaultClass) {
        this.defaultClass = defaultClass;
    }

    public String getLocalString(Class callerClass, String key, String defaultValue) {
        Class stopClass = this.defaultClass.getSuperclass();
        Class startClass = callerClass != null ? callerClass : this.defaultClass;
        ResourceBundle resources = null;
        boolean globalDone = false;
        for (Class c = startClass; c != stopClass && c != null; c = c.getSuperclass()) {
            globalDone = c == this.defaultClass;
            try {
                String value;
                StringBuffer resFileName = new StringBuffer(c.getName().substring(0, c.getName().lastIndexOf(".")));
                resFileName.append(".LocalStrings");
                resources = ResourceBundle.getBundle(resFileName.toString());
                if (resources == null || (value = resources.getString(key)) == null) continue;
                return value;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (!globalDone) {
            return this.getLocalString(null, key, defaultValue);
        }
        this.tracer().trace("No local string for " + key);
        return defaultValue;
    }

    public String getLocalString(Class callerClass, String key, String defaultFormat, Object[] arguments) {
        MessageFormat f = new MessageFormat(this.getLocalString(callerClass, key, defaultFormat));
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] == null) {
                arguments[i] = "null";
                continue;
            }
            if (arguments[i] instanceof String || arguments[i] instanceof Number || arguments[i] instanceof Date) continue;
            arguments[i] = arguments[i].toString();
        }
        return f.format(arguments);
    }

    public String getLocalString(String key, String defaultValue) {
        return this.getLocalString(null, key, defaultValue);
    }

    public String getLocalString(String key, String defaultFormat, Object[] arguments) {
        return this.getLocalString(null, key, defaultFormat, arguments);
    }

    protected Tracer tracer() {
        if (tracer == null) {
            tracer = new Tracer(this.getClass().getName());
        }
        return tracer;
    }
}

