/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import oracle.aurora.util.LocalStringManagerImpl;
import sun.tools.jar.Manifest;

public class JarUtil {
    private static LocalStringManagerImpl localStrings;
    static final String MANIFEST = "META-INF/MANIFEST.MF";

    private static void addFile(ZipOutputStream zos, File file, String name) throws IOException {
        if (name == null || name.equals("") || name.equals(".")) {
            name = JarUtil.entryName(file.getPath());
        }
        if (name.equals("") || name.equals(".")) {
            return;
        }
        boolean isDir = file.isDirectory();
        long size = isDir ? 0L : file.length();
        ZipEntry e = new ZipEntry(name);
        e.setTime(file.lastModified());
        if (size == 0L) {
            e.setMethod(0);
            e.setSize(0L);
            e.setCrc(0L);
        }
        zos.putNextEntry(e);
        if (!isDir) {
            int len;
            byte[] buf = new byte[1024];
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            while ((len = ((InputStream)is).read(buf, 0, buf.length)) != -1) {
                zos.write(buf, 0, len);
            }
            ((InputStream)is).close();
        }
        zos.closeEntry();
    }

    private static void createJar(File jarFile, String[] files, String parent, Manifest manifest) throws IOException {
        String name = null;
        FileOutputStream out = new FileOutputStream(jarFile);
        ZipOutputStream zos = new ZipOutputStream(out);
        if (manifest != null) {
            manifest.addFiles(null, files);
            ZipEntry e = new ZipEntry(MANIFEST);
            e.setTime(System.currentTimeMillis());
            zos.putNextEntry(e);
            manifest.stream((OutputStream)zos);
            zos.closeEntry();
        }
        for (int i = 0; i < files.length; ++i) {
            if (parent != null) {
                name = JarUtil.entryName(files[i].substring(parent.length() + 1));
            }
            JarUtil.addFile(zos, new File(files[i]), name);
        }
        zos.close();
    }

    public static void createJar(File jarFile, String[] files, Manifest manifest) throws IOException {
        JarUtil.createJar(jarFile, files, null, manifest);
    }

    public static void createJar(File jarFile, File dir, Manifest manifest) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException(new LocalStringManagerImpl(JarUtil.class).getLocalString("utils.notdir", "Directory {0} is not a directory.", new Object[]{dir.toString()}));
        }
        String parent = dir.getParent();
        String[] f = new String[]{dir.toString()};
        JarUtil.createJar(jarFile, JarUtil.expand(f), parent, manifest);
    }

    private static String entryName(String name) {
        if ((name = name.replace(File.separatorChar, '/')).startsWith("/")) {
            name = name.substring(1);
        } else if (name.startsWith("./")) {
            name = name.substring(2);
        }
        return name;
    }

    private static String[] expand(String[] files) {
        Vector v = new Vector();
        JarUtil.expand(null, files, v, new Hashtable());
        files = new String[v.size()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = ((File)v.elementAt(i)).getPath();
        }
        return files;
    }

    private static void expand(File dir, String[] files, Vector v, Hashtable t) {
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            File f = dir == null ? new File(files[i]) : new File(dir, files[i]);
            if (f.isFile()) {
                if (t.contains(f)) continue;
                t.put(f, f);
                v.addElement(f);
                continue;
            }
            if (f.isDirectory()) {
                File f1 = f.getPath().endsWith("/") ? f : new File(f.getPath() + "/");
                t.put(f1, f1);
                v.addElement(f1);
                JarUtil.expand(f, f.list(), v, t);
                continue;
            }
            throw new IllegalArgumentException();
        }
    }

    private static void extract(InputStream in, File dir) throws IOException {
        ZipEntry e;
        ZipInputStream zis = new ZipInputStream(in);
        while ((e = zis.getNextEntry()) != null) {
            JarUtil.extractIntoDir(zis, e, dir);
        }
    }

    public static InputStream extractFile(File jarFile, String name) throws IOException {
        FileInputStream fis = new FileInputStream(jarFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        return JarUtil.getResourceFromJar(new ZipInputStream(bis), name);
    }

    private static void extractIntoDir(ZipInputStream zis, ZipEntry e, File dir) throws IOException {
        File f = new File(dir, e.getName().replace('/', File.separatorChar));
        if (e.isDirectory()) {
            if (!f.exists()) {
                f.mkdirs();
                if (!f.isDirectory()) {
                    throw new IOException(new LocalStringManagerImpl(JarUtil.class).getLocalString("utils.direrror1", "Could not create directory {0}.", new Object[]{f.toString()}));
                }
            }
        } else {
            int len;
            File d;
            if (f.getParent() != null && !(d = new File(f.getParent())).exists()) {
                d.mkdirs();
                if (!d.isDirectory()) {
                    throw new IOException(new LocalStringManagerImpl(JarUtil.class).getLocalString("utils.direrror1", "Could not create directory {0}.", new Object[]{f.toString()}));
                }
            }
            FileOutputStream os = new FileOutputStream(f);
            byte[] b = new byte[512];
            while ((len = zis.read(b, 0, b.length)) != -1) {
                ((OutputStream)os).write(b, 0, len);
            }
            zis.closeEntry();
            ((OutputStream)os).close();
        }
    }

    private static InputStream getResourceFromJar(ZipInputStream zis, String name) throws IOException {
        ZipEntry ent = null;
        while ((ent = zis.getNextEntry()) != null) {
            String entName = ent.getName();
            if (entName.equals(name)) {
                return zis;
            }
            zis.closeEntry();
        }
        return null;
    }

    protected LocalStringManagerImpl localStrings() {
        if (localStrings == null) {
            localStrings = new LocalStringManagerImpl(this.getClass());
        }
        return localStrings;
    }

    public static void unjar(File jarFile, File directory) throws IOException {
        FileInputStream fis = new FileInputStream(jarFile);
        JarUtil.extract(new BufferedInputStream(fis), directory);
    }

    public static void unjar(InputStream jarStream, File directory) throws IOException {
        JarUtil.extract(new BufferedInputStream(jarStream), directory);
    }
}

