/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import oracle.aurora.util.BufferedOutputStream;

public class IOCopy {
    String encoding;

    public IOCopy(String encoding) {
        this.encoding = encoding;
    }

    public IOCopy() {
        this(null);
    }

    public Reader toReader(String s) {
        return new StringReader(s);
    }

    public InputStream toInputStream(byte[] bytes) {
        return new ByteInputStream(bytes, null);
    }

    public InputStream toInputStream(byte[] bytes, String name) {
        return new ByteInputStream(bytes, name);
    }

    public Reader toReader(byte[] bytes) throws IOException {
        return this.toReader(bytes, null);
    }

    public Reader toReader(byte[] bytes, String name) throws IOException {
        InputStream in = this.toInputStream(bytes, name);
        InputStreamReader r = this.encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, this.encoding);
        return r;
    }

    public byte[] toBytes(InputStream in) throws IOException {
        byte[] result;
        if (in instanceof ByteInputStream) {
            result = ((ByteInputStream)in).toBytes();
        } else {
            int want = in.available();
            want = Math.min(want, 16384);
            ByteArrayOutputStream out = new ByteArrayOutputStream(want);
            this.copy(out, in);
            out.close();
            result = out.toByteArray();
        }
        return result;
    }

    public String toString(InputStream in) throws IOException {
        InputStreamReader r = this.encoding != null ? new InputStreamReader(in, this.encoding) : new InputStreamReader(in);
        return this.toString(r, in.available());
    }

    public String toString(Reader in, int size) throws IOException {
        StringWriter out = new StringWriter();
        this.copy(out, in);
        out.close();
        return out.toString();
    }

    public String toString(Reader in) throws IOException {
        return this.toString(in, 1024);
    }

    public byte[] toEncoded(Reader in, int size) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream(3 * size);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, this.encoding);
        this.copy(w, in);
        w.close();
        return out.toByteArray();
    }

    public byte[] toEncoded(Reader in) throws IOException {
        return this.toEncoded(in, 1024);
    }

    public Reader toReader(InputStream in, String encoding) throws IOException {
        InputStreamReader r = new InputStreamReader(in, encoding);
        return r;
    }

    public Reader toReader(InputStream in) throws IOException {
        InputStreamReader r = new InputStreamReader(in);
        return r;
    }

    public void copy(Writer out, Reader in) throws IOException {
        char[] buf = new char[4096];
        int count = 0;
        while (count >= 0) {
            count = in.read(buf);
            if (count <= 0) continue;
            out.write(buf, 0, count);
        }
        out.flush();
    }

    public void copy(OutputStream out, InputStream in) throws IOException {
        byte[] buf = new byte[4096];
        int count = 0;
        while (count >= 0) {
            try {
                count = in.read(buf);
            }
            catch (EOFException ex) {
                count = -1;
            }
            if (count <= 0) continue;
            out.write(buf, 0, count);
        }
        out.flush();
    }

    public OutputStream toBuffered(OutputStream out) {
        OutputStream result = out == null ? null : (out instanceof BufferedOutputStream ? out : (out instanceof ByteArrayOutputStream ? out : new BufferedOutputStream(out)));
        return result;
    }

    public InputStream toBuffered(InputStream in) {
        InputStream result;
        if (in == null) {
            result = null;
        } else if (in instanceof BufferedInputStream) {
            result = in;
        } else if (in instanceof ByteArrayInputStream) {
            result = in;
        } else {
            final String inName = in.toString();
            result = new BufferedInputStream(in, 16384){

                public String toString() {
                    return "Buffered<" + inName + ">";
                }
            };
        }
        return result;
    }

    public static class ByteInputStream
    extends ByteArrayInputStream {
        private byte[] bytes_;
        private String name;

        public ByteInputStream(byte[] bytes, String name) {
            super(bytes);
            this.bytes_ = bytes;
            this.name = name;
        }

        public byte[] toBytes() {
            byte[] result = this.bytes_;
            if (this.pos != 0) {
                int len = this.available();
                result = new byte[len];
                System.arraycopy(this.buf, this.pos, result, 0, len);
                this.skip(len);
                try {
                    this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return result;
        }

        public String toString() {
            return this.name != null ? this.name : super.toString();
        }
    }
}

