/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.util;

import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Iterator;
import java.util.NoSuchElementException;
import oracle.aurora.util.SLexer;

public class Cons {
    public Object car;
    public Cons cdr;

    public Cons() {
        this.car = null;
        this.cdr = null;
    }

    public Cons(Object car) {
        this.car = car;
        this.cdr = null;
    }

    public Cons(Object car, Cons cdr) {
        this.car = car;
        this.cdr = cdr;
    }

    public Object car() {
        return this.car;
    }

    public Cons cdr() {
        return this.cdr;
    }

    public Object cadr() {
        return this.cdr.car;
    }

    public Cons cddr() {
        return this.cdr.cdr;
    }

    public Object caar() {
        return ((Cons)this.car).car;
    }

    public Object first() {
        return this.car;
    }

    public Cons rest() {
        return this.cdr;
    }

    public boolean hasSecond() {
        return this.cdr != null;
    }

    public Object second() {
        return this.cdr.car;
    }

    public boolean hasThird() {
        return this.cdr.cdr != null;
    }

    public Object third() {
        return this.cdr.cdr.car;
    }

    public boolean hasFourth() {
        return this.cdr.cdr.cdr != null;
    }

    public Object fourth() {
        return this.cdr.cdr.cdr.car;
    }

    public static Cons list(Object a, Object b) {
        return new Cons(a, new Cons(b, null));
    }

    public static Cons list(Object a) {
        return new Cons(a, null);
    }

    public static boolean isCons(Object a) {
        return a instanceof Cons;
    }

    public static Cons append(Cons cons1, Cons cons2) {
        return cons1 == null ? cons2 : cons1.append(cons2);
    }

    public Cons append(Cons cons) {
        Cons result = new Cons(this.car, cons);
        Cons thiscdr = this.cdr;
        Cons res = result;
        while (thiscdr != null) {
            res.cdr = new Cons(thiscdr.car, cons);
            thiscdr = thiscdr.cdr;
            res = res.cdr;
        }
        return result;
    }

    public static Cons append_d(Cons cons1, Cons cons2) {
        return cons1 == null ? cons2 : cons1.append_d(cons2);
    }

    public Cons append_d(Cons cons) {
        Cons last = this;
        while (last.cdr != null) {
            last = last.cdr;
        }
        last.cdr = cons;
        return this;
    }

    public static Cons reverse(Cons cons) {
        return cons == null ? null : cons.reverse();
    }

    public Cons reverse() {
        Cons result = null;
        Cons cons = this;
        while (cons != null) {
            result = new Cons(cons.car, result);
            cons = cons.cdr;
        }
        return result;
    }

    public static Cons reverse_d(Cons cons) {
        return cons == null ? null : cons.reverse_d();
    }

    public Cons reverse_d() {
        Cons result = null;
        Cons cons = this;
        while (cons != null) {
            Cons temp = cons.cdr;
            cons.cdr = result;
            result = cons;
            cons = temp;
        }
        return result;
    }

    public static boolean equals(Cons cons1, Cons cons2) {
        return cons1 == null ? cons2 == null : cons1.equals(cons2);
    }

    public boolean equals(Cons other) {
        if (other == null) {
            return false;
        }
        if (this.car instanceof Cons && this.cdr != null) {
            return other.car instanceof Cons && other.cdr != null && ((Cons)this.car).equals((Cons)other.car) && this.cdr.equals(other.cdr);
        }
        if (this.car instanceof Cons) {
            return this.cdr == other.cdr && this.car instanceof Cons && ((Cons)this.car).equals((Cons)other.car);
        }
        if (this.cdr != null) {
            return this.car == other.car && other.cdr != null && this.cdr.equals(other.cdr);
        }
        return this.car == other.car && this.cdr == other.cdr;
    }

    public static Cons subst(Cons cons, Object s1, Object s2) {
        return cons == null ? cons : cons.subst(s1, s2);
    }

    public Cons subst(Object s1, Object s2) {
        if (this.car instanceof Cons && this.cdr != null) {
            Cons newcar = ((Cons)this.car).subst(s1, s2);
            Cons newcdr = this.cdr.subst(s1, s2);
            return this.car == newcar && this.cdr == newcdr ? this : new Cons(newcar, newcdr);
        }
        if (this.car instanceof Cons) {
            Cons newcar = ((Cons)this.car).subst(s1, s2);
            return this.car == newcar ? this : new Cons(newcar, this.cdr);
        }
        if (this.cdr != null) {
            Cons newcdr = this.cdr.subst(s1, s2);
            return this.cdr == newcdr && s2 != this.car ? this : new Cons(s2 == this.car ? s1 : this.car, newcdr);
        }
        if (s2.equals(this.car)) {
            return new Cons(s1, this.cdr);
        }
        return this;
    }

    public static Cons substq(Cons cons, Object s1, Object s2) {
        return cons == null ? cons : cons.substq(s1, s2);
    }

    public Cons substq(Object s1, Object s2) {
        if (this.car instanceof Cons && this.cdr != null) {
            Cons newcar = ((Cons)this.car).substq(s1, s2);
            Cons newcdr = this.cdr.substq(s1, s2);
            return this.car == newcar && this.cdr == newcdr ? this : new Cons(newcar, newcdr);
        }
        if (this.car instanceof Cons) {
            Cons newcar = ((Cons)this.car).substq(s1, s2);
            return this.car == newcar ? this : new Cons(newcar, this.cdr);
        }
        if (this.cdr != null) {
            Cons newcdr = this.cdr.substq(s1, s2);
            return this.cdr == newcdr && s2 != this.car ? this : new Cons(s2 == this.car ? s1 : this.car, newcdr);
        }
        if (s2 == this.car) {
            return new Cons(s1, this.cdr);
        }
        return this;
    }

    public static Cons member(Cons cons, Object obj) {
        return cons == null ? null : cons.member(obj);
    }

    public Cons member(Object obj) {
        Cons cons = this;
        while (cons != null) {
            if (obj.equals(cons.car)) {
                return cons;
            }
            cons = cons.cdr;
        }
        return null;
    }

    public static Cons memq(Cons cons, Object obj) {
        return cons == null ? null : cons.memq(obj);
    }

    public Cons memq(Object obj) {
        Cons cons = this;
        while (cons != null) {
            if (obj == cons.car) {
                return cons;
            }
            cons = cons.cdr;
        }
        return null;
    }

    public static Cons remove(Cons cons, Object o) {
        return cons == null ? null : cons.remove(o);
    }

    public Cons remove(Object o) {
        Cons result = null;
        Cons cons = this;
        while (cons != null) {
            if (!cons.car.equals(o)) {
                result = new Cons(cons.car, result);
            }
            cons = cons.cdr;
        }
        return Cons.reverse_d(result);
    }

    public static Cons remq(Cons cons, Object o) {
        return cons == null ? null : cons.remq(o);
    }

    public Cons remq(Object o) {
        Cons result = null;
        Cons cons = this;
        while (cons != null) {
            if (cons.car != o) {
                result = new Cons(cons.car, result);
            }
            cons = cons.cdr;
        }
        return Cons.reverse_d(result);
    }

    public static Cons delete(Cons cons, Object o) {
        return cons == null ? null : cons.delete(o);
    }

    public Cons delete(Object o) {
        Cons cons = this;
        Cons ret = null;
        while (cons != null) {
            if (o.equals(cons.car)) {
                cons = cons.cdr;
                continue;
            }
            ret = cons;
            break;
        }
        if (cons == null) {
            return ret;
        }
        while (cons.cdr != null) {
            if (o.equals(cons.cdr.car)) {
                cons.cdr = cons.cdr.cdr;
                continue;
            }
            cons = cons.cdr;
        }
        return ret;
    }

    public static Cons delq(Cons cons, Object o) {
        return cons == null ? null : cons.delq(o);
    }

    public Cons delq(Object o) {
        Cons cons = this;
        Cons ret = null;
        while (cons != null) {
            if (o == cons.car) {
                cons = cons.cdr;
                continue;
            }
            ret = cons;
            break;
        }
        if (cons == null) {
            return ret;
        }
        while (cons.cdr != null) {
            if (o == cons.cdr.car) {
                cons.cdr = cons.cdr.cdr;
                continue;
            }
            cons = cons.cdr;
        }
        return ret;
    }

    public static Cons last(Cons cons) {
        return cons == null ? null : cons.last();
    }

    public Cons last() {
        Cons cons = this;
        while (cons.cdr != null) {
            cons = cons.cdr;
        }
        return cons;
    }

    public static int length(Cons cons) {
        return cons == null ? 0 : cons.length();
    }

    public int length() {
        int count = 1;
        Cons cons = this.cdr;
        while (cons != null) {
            ++count;
            cons = cons.cdr;
        }
        return count;
    }

    public static Cons read(Reader r) throws IOException {
        return Cons.readList(new SLexer(r), false);
    }

    public void write(Writer w) throws IOException {
        w.write("(");
        Cons cons = this;
        while (cons != null) {
            if (cons.car == null) {
                w.write("()");
            } else if (cons.car instanceof Cons) {
                ((Cons)cons.car).write(w);
            } else {
                w.write(cons.car.toString());
            }
            if ((cons = cons.cdr) == null) continue;
            w.write(" ");
        }
        w.write(")");
        w.flush();
    }

    public String toString() {
        StringWriter s = new StringWriter();
        try {
            this.write(s);
        }
        catch (IOException e) {
            throw (RuntimeException)new RuntimeException("IO failure in Cons.toString()").fillInStackTrace();
        }
        return s.toString();
    }

    public static Iterator nullIterator() {
        return new NullIterator();
    }

    public Iterator iterator() {
        return new ConsIterator();
    }

    public static void main(String[] args) throws IOException {
        FileReader reader = new FileReader(args[0]);
        Cons cons = Cons.read(reader);
        cons.write(new OutputStreamWriter(System.out));
    }

    protected static Cons readList(SLexer lex, boolean balance) throws IOException {
        int code;
        Cons result = null;
        block6: while (true) {
            code = 0;
            code = lex.lexan();
            switch (code) {
                case 1: {
                    result = new Cons(Cons.readList(lex, true), result);
                    continue block6;
                }
                case 2: {
                    String ident = lex.ident();
                    NumberFormat nf = NumberFormat.getNumberInstance();
                    ParsePosition pp = new ParsePosition(0);
                    Object obj = nf.parse(ident, pp);
                    if (pp.getIndex() == 0) {
                        obj = ident.intern();
                        if (obj == "null") {
                            obj = null;
                        }
                    } else {
                        if (obj instanceof Long) {
                            if (ident.indexOf(46) != -1) {
                                obj = new Double(((Long)obj).doubleValue());
                            } else if (Character.toUpperCase(ident.charAt(ident.length() - 1)) != 'L') {
                                obj = new Integer(((Long)obj).intValue());
                            }
                        }
                        if (obj instanceof Double && Character.toUpperCase(ident.charAt(ident.length() - 1)) == 'F') {
                            obj = new Float(((Double)obj).floatValue());
                        }
                    }
                    result = new Cons(obj, result);
                    continue block6;
                }
                case 3: {
                    if (!balance) {
                        throw new RuntimeException("Unbalanced ')'");
                    }
                    return Cons.reverse_d(result);
                }
                case 0: {
                    if (balance) {
                        throw new RuntimeException("Missing ')'");
                    }
                    return Cons.reverse_d(result);
                }
            }
            break;
        }
        throw new RuntimeException("Bad lexan code: " + code);
    }

    private static class NullIterator
    implements Iterator {
        NullIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    private class ConsIterator
    implements Iterator {
        Cons last;
        Cons next;

        ConsIterator() {
            this.next = Cons.this;
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Object next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.last = this.next;
            this.next = this.next.cdr;
            return this.last.car;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            if (Cons.this.delq(this.last.car) != Cons.this) {
                throw new RuntimeException("Removing first element with cons iterator is not supported");
            }
            this.last = null;
        }
    }
}

