/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.security.PolicyTable;
import oracle.aurora.rdbms.security.PolicyTableRow;
import oracle.aurora.rdbms.security.RowCache;
import oracle.aurora.rdbms.security.RowData;
import oracle.aurora.rdbms.security.RowInCache;
import oracle.aurora.vm.Id;

class TypePermissions
extends PermissionCollection {
    private Id schema;
    PolicyTable table;
    private Class permissionClass;
    private PermissionCollection grantAccum;
    private Vector grantVector;
    private Permission[] grantList;
    private Vector restrictVector;
    private Permission[] restrictList;

    TypePermissions(PolicyTable table, Id schema, Class permissionClass, PermissionCollection collector) {
        this.table = table;
        this.schema = schema;
        this.permissionClass = permissionClass;
        this.grantAccum = collector;
        this.grantVector = new Vector();
        this.restrictVector = new Vector();
        table.usingRowCache = true;
        this.initFromRowCache();
    }

    public void add(Permission permission) {
    }

    public Enumeration elements() {
        return this.grantVector.elements();
    }

    public String toString() {
        return this.table.tableName + "[" + this.schema + "," + this.permissionClass + "]";
    }

    String toMultiLineString(String pfx) {
        int x;
        StringBuffer buf = new StringBuffer();
        buf.append(pfx).append(this.toString()).append("\n");
        pfx = pfx + "  ";
        buf.append(pfx).append("grantAccum = " + this.grantAccum).append("\n");
        for (x = 0; x < this.grantList.length; ++x) {
            buf.append(pfx).append("grantList[" + x + "] " + this.grantList[x]).append("\n");
        }
        for (x = 0; x < this.restrictList.length; ++x) {
            buf.append(pfx).append("restrictList[" + x + "] " + this.restrictList[x]).append("\n");
        }
        return buf.toString();
    }

    public boolean implies(Permission implicand) {
        boolean result = this.grantAccum.implies(implicand);
        for (int xRestrict = 0; xRestrict < this.restrictList.length && result; ++xRestrict) {
            Permission restriction = this.restrictList[xRestrict];
            if (!restriction.implies(implicand)) continue;
            boolean satisfied = false;
            for (int xGrant = 0; xGrant < this.grantList.length && !satisfied; ++xGrant) {
                Permission grant = this.grantList[xGrant];
                satisfied = restriction.implies(grant) && grant.implies(implicand);
            }
            if (satisfied) continue;
            result = false;
        }
        TypePermissions typePermissions = this;
        int dLevel = typePermissions.table.debugLevel();
        if (dLevel > 0) {
            if (result) {
                if (dLevel > 3) {
                    PolicyTable.output(this + " implies " + implicand);
                } else if (dLevel > 4) {
                    PolicyTable.output(this + "(" + this.grantAccum + ") implies " + implicand);
                }
            } else {
                String msg = this + " does not imply " + implicand;
                switch (dLevel) {
                    case 1: {
                        PolicyTable.output(msg);
                        break;
                    }
                    case 2: {
                        new Exception(msg).printStackTrace();
                        break;
                    }
                    default: {
                        PolicyTable.output("failed: grants " + this.grantAccum);
                        new Exception(msg).printStackTrace();
                    }
                }
            }
        }
        return result;
    }

    void initFromRowCache() {
        RowCache cache = this.table.getRowCache();
        this.addRowsInCache(cache.rows(this.schema.getNumber(), this.permissionClass));
        this.addRowsInCache(cache.rows(1L, this.permissionClass));
        int[] ids = ((Schema)this.schema).getGrantedRoles();
        if (ids != null) {
            for (int xId = 0; xId < ids.length; ++xId) {
                this.addRowsInCache(cache.rows(ids[xId], this.permissionClass));
            }
        }
        this.initLists();
    }

    void addRowsInCache(Iterator rows) {
        while (rows.hasNext()) {
            RowInCache nextRow = (RowInCache)rows.next();
            this.addRow(nextRow);
        }
    }

    void addRow(RowData row, Permission permission) {
        if (row.status == 2) {
            if (row.kind == 0) {
                this.grantAccum.add(permission);
                this.grantVector.add(permission);
            } else {
                this.restrictVector.add(permission);
            }
        }
    }

    void addRow(PolicyTableRow row) {
        try {
            this.addRow(row, row.instantiate());
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    void addRow(RowInCache row) {
        try {
            this.addRow(row, row.instantiate());
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
    }

    void initLists() {
        int gLen = this.grantVector.size();
        this.grantList = new Permission[gLen];
        this.grantVector.toArray(this.grantList);
        int rLen = this.restrictVector.size();
        this.restrictList = new Permission[rLen];
        this.restrictVector.toArray(this.restrictList);
    }
}

