/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.UnsupportedEncodingException;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.HandleHolder;
import oracle.aurora.rdbms.KGEException;
import oracle.aurora.rdbms.ModifyPermissionException;
import oracle.aurora.rdbms.NameInUseException;
import oracle.aurora.rdbms.NoSchema;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.Resolver;
import oracle.aurora.rdbms.ResourceHandle;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.WouldReplaceException;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.io.MalformedInputException;

public final class SourceHandle
extends Handle {
    char[] chars;

    SourceHandle(String name, Schema schema, long index, byte[] timestamp) {
        super(name, schema, index, timestamp);
    }

    public int type() {
        return 28;
    }

    public void setResolver(Resolver newResolver) throws ObjectTypeChangedException {
        this.doSetResolver(newResolver);
    }

    private static native void create(byte[] var0, String var1, int var2, String[] var3, int[] var4, boolean var5, boolean var6, boolean var7, HandleHolder var8, String var9) throws NameInUseException, WouldReplaceException, ModifyPermissionException;

    public static SourceHandle create(byte[] UTF8Source, String name, Schema schema, Resolver resolver, boolean definers, boolean replace, boolean andCompile) throws NameInUseException, WouldReplaceException, ModifyPermissionException {
        if (schema == null) {
            schema = Schema.currentSchema();
        }
        if (schema instanceof NoSchema) {
            throw new IllegalArgumentException("Schema instanceof NoSchema");
        }
        if (resolver == null) {
            resolver = Resolver.defaultCreateHandleResolver(schema);
        }
        int id = schema.ownerNumber();
        HandleHolder holder = new HandleHolder();
        try {
            SourceHandle.create(UTF8Source, name, id, resolver.patterns(), resolver.ownerNumbers(), definers, replace, andCompile, holder, null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow("SourceHandle.create for " + schema.toString() + "." + name);
        }
        SourceHandle h = (SourceHandle)holder.handle;
        if (h == null) {
            h = new SourceHandle(holder.name, schema, holder.index, holder.timestamp);
        }
        h.data = UTF8Source;
        return h;
    }

    public static SourceHandle create(byte[] UTF8Source, String name, Schema schema, Resolver resolver, boolean definers, boolean replace) throws NameInUseException, WouldReplaceException, ModifyPermissionException {
        return SourceHandle.create(UTF8Source, name, schema, resolver, definers, replace, false);
    }

    public static SourceHandle create(char[] UNICODEsource, String name, Schema schema, Resolver resolver, boolean definers, boolean replace, boolean andCompile) throws NameInUseException, WouldReplaceException, ModifyPermissionException {
        byte[] UTF8Source = null;
        try {
            UTF8Source = CharToByteConverter.getConverter((String)"UTF8").convertAll(UNICODEsource);
        }
        catch (MalformedInputException e) {
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        if (UTF8Source == null) {
            return null;
        }
        return SourceHandle.create(UTF8Source, name, schema, resolver, definers, replace, andCompile);
    }

    public static SourceHandle create(char[] UNICODEsource, String name, Schema schema, Resolver resolver, boolean definers, boolean replace) throws NameInUseException, WouldReplaceException, ModifyPermissionException {
        return SourceHandle.create(UNICODEsource, name, schema, resolver, definers, replace, false);
    }

    public static SourceHandle create(String source, String name, Schema schema, Resolver resolver, boolean definers, boolean replace, boolean andCompile) throws NameInUseException, WouldReplaceException, ModifyPermissionException {
        return SourceHandle.create(source.toCharArray(), name, schema, resolver, definers, replace, andCompile);
    }

    public static SourceHandle create(String source, String name, Schema schema, Resolver resolver, boolean definers, boolean replace) throws NameInUseException, WouldReplaceException, ModifyPermissionException {
        return SourceHandle.create(source, name, schema, resolver, definers, replace, false);
    }

    public static SourceHandle intern(HandleHolder holder) {
        Schema schema;
        SourceHandle h = (SourceHandle)holder.handle;
        if (h == null && (schema = Schema.lookupFixed(holder.schemaNumber)) != null) {
            h = new SourceHandle(holder.name, schema, holder.index, holder.timestamp);
        }
        return h;
    }

    private native HandleHolder[] derivees(boolean var1, String var2) throws ObjectTypeChangedException;

    private Handle[] derivees(boolean classesp) throws ObjectTypeChangedException {
        boolean cl = classesp;
        HandleHolder[] holders = null;
        try {
            holders = this.derivees(cl, null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".derivees");
        }
        if (holders == null) {
            return null;
        }
        int length = holders.length;
        if (classesp) {
            Handle[] handles = new ClassHandle[length];
            for (int i = 0; i < length; ++i) {
                handles[i] = ClassHandle.intern(holders[i]);
            }
            return handles;
        }
        Handle[] handles = new ResourceHandle[length];
        for (int i = 0; i < length; ++i) {
            handles[i] = ResourceHandle.intern(holders[i]);
        }
        return handles;
    }

    public ClassHandle[] derivedClasses() throws ObjectTypeChangedException {
        return (ClassHandle[])this.derivees(true);
    }

    public ResourceHandle[] derivedResources() throws ObjectTypeChangedException {
        return (ResourceHandle[])this.derivees(false);
    }

    public char[] source() throws ObjectTypeChangedException {
        if (this.chars == null) {
            try {
                this.chars = ByteToCharConverter.getConverter((String)"UTF8").convertAll(this.data());
            }
            catch (MalformedInputException e) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return this.chars;
    }
}

