/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import oracle.aurora.rdbms.Resolver;
import oracle.aurora.rdbms.ResolverTerm;
import oracle.aurora.rdbms.Schema;

public class ResolverWalker {
    private Resolver resolver;
    private int index;
    private String target;
    private String jarNamePrefix;

    public ResolverWalker(Resolver resolver) {
        this.resolver = resolver;
    }

    public ResolverWalker(Resolver resolver, String target) {
        this.resolver = resolver;
        this.reset(target);
    }

    public void reset(String target) {
        this.target = target;
        this.index = 0;
    }

    public String jarPrefix() {
        return this.jarNamePrefix;
    }

    public Schema next() {
        if (this.target != null) {
            while (this.index < this.resolver.length()) {
                int jarEndPos;
                ResolverTerm term = this.resolver.term(this.index++);
                String pattern = term.pattern();
                this.jarNamePrefix = null;
                if (pattern.startsWith("///") && (jarEndPos = pattern.lastIndexOf("///")) > 3) {
                    this.jarNamePrefix = pattern.substring(3, jarEndPos += 3);
                    pattern = pattern.substring(jarEndPos);
                }
                if (!(pattern.endsWith("*") ? pattern.length() == 1 || this.target.startsWith(pattern.substring(0, pattern.length() - 1)) : this.target.equals(pattern))) continue;
                return term.schema();
            }
            this.target = null;
        }
        return null;
    }
}

