/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.KGEException;
import oracle.aurora.util.SeekableInputStream;

class HandleInput
extends InputStream
implements SeekableInputStream {
    Handle handle;
    int total_available_ = -1;
    int pos;
    boolean closedp;
    boolean forCompiler;

    public HandleInput(Handle handle, boolean forCompiler) throws IOException {
        this.handle = handle;
        this.pos = 0;
        this.closedp = false;
        this.forCompiler = forCompiler;
    }

    public HandleInput(Handle handle) throws IOException {
        this(handle, false);
    }

    public int read() throws IOException {
        int x = 0;
        try {
            x = this.read(null, 0, 1, null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".read()");
        }
        return x;
    }

    private native int read(byte[] var1, int var2, int var3, String var4) throws IOException, KGEException;

    public int read(byte[] b, int off, int len) throws IOException {
        int x = 0;
        try {
            x = this.read(b, off, len, null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".read(byte[], int, int)");
        }
        return x;
    }

    private native int total_available(String var1) throws KGEException;

    private int total_available() {
        int x = 0;
        try {
            x = this.total_available(null);
        }
        catch (KGEException e) {
            e.amendMessageAndRethrow(this + ".total_available");
        }
        return x;
    }

    public int available() {
        if (this.total_available_ == -1) {
            this.total_available_ = this.total_available();
        }
        return this.total_available_ - this.pos;
    }

    public void seek(long position) throws IOException {
        if (position < 0L) {
            throw new IOException("Seek position cannot be negative");
        }
        if (position > (long)this.total_available_) {
            throw new EOFException("Attempt to seek beyond end of stream");
        }
        this.pos = (int)position;
    }

    public long skip(long n) {
        int a;
        if (n < (long)(-this.pos)) {
            n = -this.pos;
        } else if (n > 0L && n > (long)(a = this.available())) {
            n = a;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    public void close() throws IOException {
        this.close_();
    }

    private native void close_() throws IOException;

    Handle getHandle() {
        return this.handle;
    }
}

