/*
 * Decompiled with CFR 0.152.
 */
package oracle.aurora.rdbms;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import oracle.aurora.rdbms.ClassHandle;
import oracle.aurora.rdbms.ExecutePermissionException;
import oracle.aurora.rdbms.Handle;
import oracle.aurora.rdbms.InvalidResolverPatternException;
import oracle.aurora.rdbms.ObjectTypeChangedException;
import oracle.aurora.rdbms.Resolver;
import oracle.aurora.rdbms.ResourceHandle;
import oracle.aurora.rdbms.Schema;
import oracle.aurora.rdbms.SchemaNotFoundException;
import oracle.aurora.vm.ClassNotResolvedException;

public class ClassResolver
extends ClassLoader {
    private Hashtable cache = new Hashtable();
    private Resolver resolver;

    public ClassResolver() {
        this(Resolver.defaultResolver());
    }

    public ClassResolver(String spec) throws InvalidResolverPatternException, SchemaNotFoundException {
        this(new Resolver(spec));
    }

    public ClassResolver(Resolver spec) {
        if (spec.terms.length == 0) {
            throw new IllegalArgumentException("Cannot create an empty ClassResolver");
        }
        this.resolver = spec;
    }

    public InputStream getResourceAsStream(String name) {
        ResourceHandle h = Handle.lookupResource(name, this.resolver);
        if (h == null) {
            return null;
        }
        try {
            return h.inputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = (Class)this.cache.get(name);
        if (c != null) {
            return c;
        }
        ClassHandle h = Handle.lookupClass(name, this.resolver);
        if (h == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            c = h.loadClass();
        }
        catch (ObjectTypeChangedException e) {
            e.printStackTrace();
            throw new InternalError(h + " changed type in ClassResolver.loadClass");
        }
        if (c != null) {
            this.cache.put(name, c);
            return c;
        }
        boolean hasExecPriv = true;
        try {
            hasExecPriv = h.hasExecutePrivilege(Schema.currentSchema());
        }
        catch (ObjectTypeChangedException ehe) {
            ehe.printStackTrace();
            System.err.println(ehe.getMessage());
            throw new ClassNotFoundException(name);
        }
        if (hasExecPriv) {
            throw new ClassNotResolvedException(name + " in <" + this.resolver + ">");
        }
        throw new ExecutePermissionException(name + " in <" + this.resolver + ">");
    }
}

