/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.wls;

import java.io.File;
import java.net.UnknownHostException;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import oracle.jrf.Port;
import oracle.jrf.PortConfig;
import oracle.jrf.PortabilityLayerException;
import oracle.jrf.ServerPlatformSupportFactory;
import oracle.jrf.i18n.JRFMessageBundleHelper;
import oracle.jrf.wls.WlsServerPlatformSupport;
import weblogic.management.configuration.ClusterMBean;
import weblogic.management.configuration.NetworkAccessPointMBean;
import weblogic.management.configuration.PartitionMBean;
import weblogic.management.configuration.SSLMBean;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.TargetMBean;
import weblogic.management.configuration.VirtualHostMBean;
import weblogic.management.configuration.VirtualTargetMBean;
import weblogic.management.configuration.WebServerMBean;
import weblogic.management.utils.PartitionUtils;

public final class WlsPortConfig
extends PortConfig {
    private static final long serialVersionUID = 1L;
    private boolean isSSL = false;
    private String serverName;
    private String serverHost;
    private String clusterName;
    private String clusterJndiAddress;

    @Override
    public String[] getSupportedPortProtocols() {
        return new String[]{"http", "https", "t3", "t3s", "iiop", "iiops"};
    }

    WlsPortConfig() throws Exception {
        ServerMBean server = WlsServerPlatformSupport.getLocalServerMBean();
        this.initialize(server);
    }

    WlsPortConfig(String serverId) throws Exception {
        ServerMBean server = WlsServerPlatformSupport.getServerMBean(serverId);
        if (server == null) {
            throw new PortabilityLayerException(JRFMessageBundleHelper.msg.getString("JRF-20013", new String[]{serverId}));
        }
        this.initialize(server);
    }

    @Override
    public boolean isSSLRequired() {
        return this.isSSL;
    }

    @Override
    public boolean isSSLRequired(ServerMBean server) {
        boolean ismySSL = false;
        SSLMBean ssl = server.getSSL();
        if (ssl.isEnabled()) {
            ismySSL = true;
        }
        return ismySSL;
    }

    private void initialize(ServerMBean server) throws Exception {
        this.serverName = server.getName();
        this.serverHost = server.getListenAddress();
        if (this.serverHost == null || this.serverHost.trim().isEmpty()) {
            this.serverHost = this.getLocalHost();
        }
        this.clusterJndiAddress = null;
        ClusterMBean cluster = server.getCluster();
        if (cluster != null) {
            this.clusterName = server.getName();
            String clusterAddr = cluster.getClusterAddress();
            if (clusterAddr != null && !clusterAddr.trim().isEmpty()) {
                this.clusterJndiAddress = clusterAddr;
            }
            this.initClusterFrontendWebPorts(cluster);
            for (ServerMBean member : cluster.getServers()) {
                this.initPorts(member);
            }
        } else {
            this.initPorts(server);
        }
        File runningSrvDir = new File(ServerPlatformSupportFactory.getInstance().getServerConfigDirectory());
        this.parsePortConfigPropertiesFile(new File(runningSrvDir.getParentFile(), this.serverName));
    }

    private void initClusterFrontendWebPorts(ClusterMBean cluster) throws UnknownHostException {
        String hostName = cluster.getFrontendHost();
        if (hostName != null && !hostName.isEmpty()) {
            Integer portInt = cluster.getFrontendHTTPPort();
            if (portInt != null && portInt > 0) {
                this.setClusterFrontEndHttpPort(new Port("http", hostName, portInt, this));
            }
            if ((portInt = Integer.valueOf(cluster.getFrontendHTTPSPort())) != null && portInt > 0) {
                this.setClusterFrontEndHttpSslPort(new Port("https", hostName, portInt, this));
            }
        }
    }

    private void initPorts(ServerMBean server) throws UnknownHostException {
        this.initJndiPorts(server);
        this.initServerWebPorts(server);
    }

    private void initJndiPorts(ServerMBean server) throws UnknownHostException {
        SSLMBean ssl;
        String hostName = server.getListenAddress();
        if (hostName == null || hostName.trim().isEmpty()) {
            hostName = this.getLocalHost();
        }
        if ((ssl = server.getSSL()).isEnabled() && ssl.isListenPortEnabled()) {
            this.addJndiPortHelper(server, hostName, "t3s", ssl.getListenPort());
            if (server.isIIOPEnabled()) {
                this.addJndiPortHelper(server, hostName, "iiops", ssl.getListenPort());
            }
        }
        if (ssl.isEnabled()) {
            this.isSSL = true;
        }
        if (server.isListenPortEnabled()) {
            this.addJndiPortHelper(server, hostName, "t3", server.getListenPort());
            if (server.isIIOPEnabled()) {
                this.addJndiPortHelper(server, hostName, "iiop", server.getListenPort());
            }
        }
    }

    private void addJndiPortHelper(ServerMBean server, String hostName, String protocol, int port) throws UnknownHostException {
        Port portInstance = new Port(protocol, hostName, port, this);
        if (this.serverName.equals(server.getName())) {
            this.addServerPort(portInstance);
        }
        if (this.isClustered()) {
            this.addClusterMemberPort(portInstance);
        }
    }

    private void initServerWebPorts(ServerMBean server) throws UnknownHostException {
        SSLMBean ssl;
        Port webSrvHttpPort = null;
        Port webSrvHttpsPort = null;
        Port nativeHttpPort = null;
        Port nativeHttpsPort = null;
        WebServerMBean webServer = server.getWebServer();
        String hostName = webServer.getFrontendHost();
        if (hostName != null && !hostName.isEmpty()) {
            Integer portInt = webServer.getFrontendHTTPPort();
            if (portInt != null && portInt > 0) {
                webSrvHttpPort = new Port("http", hostName, portInt, this);
            }
            if ((portInt = Integer.valueOf(webServer.getFrontendHTTPSPort())) != null && portInt > 0) {
                webSrvHttpsPort = new Port("https", hostName, portInt, this);
            }
        }
        if ((hostName = server.getListenAddress()) == null || hostName.trim().isEmpty()) {
            hostName = this.getLocalHost();
        }
        if (server.isListenPortEnabled()) {
            nativeHttpPort = new Port("http", hostName, server.getListenPort(), this);
        }
        if ((ssl = server.getSSL()).isEnabled()) {
            nativeHttpsPort = new Port("https", hostName, ssl.getListenPort(), this);
        }
        if (this.serverName.equals(server.getName())) {
            this.addServerPort(nativeHttpPort);
            this.addServerPort(nativeHttpsPort);
            this.setFrontEndHttpPort(webSrvHttpPort);
            this.setFrontEndHttpSslPort(webSrvHttpsPort);
        }
        if (this.isClustered()) {
            if (nativeHttpPort != null) {
                this.addClusterMemberPort(nativeHttpPort);
            }
            if (nativeHttpsPort != null) {
                this.addClusterMemberPort(nativeHttpsPort);
            }
        }
    }

    @Override
    public boolean isClustered() {
        return this.clusterName != null;
    }

    @Override
    protected String[] getDefaultJndiProtocols() {
        return new String[]{"t3", "iiop"};
    }

    @Override
    protected String[] getDefaultJndiSslProtocols() {
        return new String[]{"t3s", "iiops"};
    }

    @Override
    public String getJndiProviderURL() {
        String url = this.getClusterAddrJndiProviderURL(this.getDefaultJndiProtocols());
        return url == null ? super.getJndiProviderURL() : url;
    }

    @Override
    public String getJndiSslProviderURL() {
        String url = this.getClusterAddrJndiProviderURL(this.getDefaultJndiSslProtocols());
        return url == null ? super.getJndiSslProviderURL() : url;
    }

    private String getClusterAddrJndiProviderURL(String[] defaultProtocols) {
        if (this.clusterJndiAddress != null) {
            for (String defaultProtocol : defaultProtocols) {
                Port port = this.getServerPort(defaultProtocol);
                if (port == null) continue;
                if (this.clusterJndiAddress.indexOf(44) > 0) {
                    return null;
                }
                int portIndex = this.clusterJndiAddress.indexOf(58);
                if (portIndex > 0) {
                    String clusterAddrHost = this.clusterJndiAddress.substring(0, portIndex);
                    return port.getProtocol() + "://" + clusterAddrHost + ":" + port.getPort();
                }
                return port.getProtocol() + "://" + this.clusterJndiAddress + ":" + port.getPort();
            }
        }
        return null;
    }

    @Override
    public String getJndiProviderURL(String partitionName) {
        for (String defaultProtocol : this.getDefaultJndiProtocols()) {
            String url = this.getJndiProviderURLForProtocol(defaultProtocol, partitionName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public String getJndiSslProviderURL(String partitionName) {
        for (String defaultProtocol : this.getDefaultJndiSslProtocols()) {
            String url = this.getJndiProviderURLForProtocol(defaultProtocol, partitionName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    private String getJndiProviderURLForProtocol(String protocol, String partitionName) {
        Port partitionPort;
        Port serverPort = this.getServerPort(protocol);
        if (serverPort != null && (partitionPort = this.getPartitionPort(serverPort, partitionName)) != null) {
            PortConfig partitionPortConfig = partitionPort.getPortConfig();
            if (partitionPortConfig != null && partitionPortConfig.isClustered()) {
                return partitionPortConfig.getClusterJndiProviderURL(protocol);
            }
            return partitionPort.getDnsResolvedURLString();
        }
        return null;
    }

    @Override
    protected void registerPortConfigChangeListener(NotificationListener listener) {
        ServerMBean server = WlsServerPlatformSupport.getLocalServerMBean();
        ClusterMBean cluster = server.getCluster();
        if (cluster != null) {
            AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
            filter.enableAttribute("FrontendHost");
            filter.enableAttribute("FrontendHTTPPort");
            filter.enableAttribute("FrontendHTTPSPort");
            filter.enableAttribute("Servers");
            cluster.addNotificationListener(listener, (NotificationFilter)filter, null);
            for (ServerMBean member : cluster.getServers()) {
                this.registerPortConfigChangeListener(member, listener);
            }
        } else {
            this.registerPortConfigChangeListener(server, listener);
        }
    }

    private void registerPortConfigChangeListener(ServerMBean server, NotificationListener listener) {
        AttributeChangeNotificationFilter filter = new AttributeChangeNotificationFilter();
        filter.enableAttribute("ListenPort");
        filter.enableAttribute("ListenPortEnabled");
        filter.enableAttribute("ListenAddress");
        filter.enableAttribute("IIOPEnabled");
        filter.enableAttribute("Cluster");
        server.addNotificationListener(listener, (NotificationFilter)filter, null);
        SSLMBean ssl = server.getSSL();
        filter = new AttributeChangeNotificationFilter();
        filter.enableAttribute("ListenPort");
        filter.enableAttribute("Enabled");
        ssl.addNotificationListener(listener, (NotificationFilter)filter, null);
        WebServerMBean webSrv = server.getWebServer();
        if (webSrv != null) {
            filter = new AttributeChangeNotificationFilter();
            filter.enableAttribute("FrontendHost");
            filter.enableAttribute("FrontendHTTPPort");
            filter.enableAttribute("FrontendHTTPSPort");
            webSrv.addNotificationListener(listener, (NotificationFilter)filter, null);
        }
    }

    @Override
    public Port getHttpPort(String partitionName) {
        return this.getPartitionPort(this.getHttpPort(), partitionName);
    }

    @Override
    public Port getHttpSslPort(String partitionName) {
        return this.getPartitionPort(this.getHttpSslPort(), partitionName);
    }

    private Port getPartitionPort(Port serverPort, String partitionName) {
        TargetMBean[] availableTargets;
        if (serverPort == null) {
            return null;
        }
        if (partitionName == null) {
            return serverPort;
        }
        PartitionMBean partitionMBean = WlsServerPlatformSupport.getPartitionMBean(partitionName);
        if (partitionMBean == null) {
            return null;
        }
        TargetMBean[] defaultTargets = partitionMBean.getDefaultTargets();
        if (defaultTargets != null && defaultTargets.length > 0) {
            for (TargetMBean target : defaultTargets) {
                if (target instanceof VirtualTargetMBean) {
                    if (!this.matchingVirtualTarget((VirtualTargetMBean)target)) continue;
                    return this.getVirtualTargetPort((VirtualTargetMBean)target, serverPort);
                }
                if (!(target instanceof VirtualHostMBean)) continue;
                return this.getVirtualHostPort((VirtualHostMBean)target, serverPort);
            }
        }
        if ((availableTargets = partitionMBean.getAvailableTargets()) != null && availableTargets.length > 0) {
            for (TargetMBean target : availableTargets) {
                if (target instanceof VirtualTargetMBean) {
                    if (!this.matchingVirtualTarget((VirtualTargetMBean)target)) continue;
                    return this.getVirtualTargetPort((VirtualTargetMBean)target, serverPort);
                }
                if (!(target instanceof VirtualHostMBean)) continue;
                return this.getVirtualHostPort((VirtualHostMBean)target, serverPort);
            }
        }
        return serverPort;
    }

    private boolean matchingVirtualTarget(VirtualTargetMBean vt) {
        TargetMBean[] targets = vt.getTargets();
        if (targets != null) {
            for (TargetMBean target : targets) {
                if (!this.serverName.equals(target.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private Port getVirtualHostPort(VirtualHostMBean vhMBean, Port serverPort) {
        try {
            String[] vhs = vhMBean.getVirtualHostNames();
            if (vhs != null && vhs.length > 0) {
                String uriPath = vhMBean.getUriPath();
                if (uriPath != null && uriPath.trim().length() > 0) {
                    return new Port(serverPort.getProtocol(), vhs[0], serverPort.getPort(), this, uriPath.trim(), false);
                }
                return new Port(serverPort.getProtocol(), vhs[0], serverPort.getPort(), this, null, false);
            }
            String channelName = vhMBean.getNetworkAccessPoint();
            if (channelName != null) {
                NetworkAccessPointMBean[] channels;
                ServerMBean server = WlsServerPlatformSupport.getLocalServerMBean();
                for (NetworkAccessPointMBean channel : channels = server.getNetworkAccessPoints()) {
                    if (!channelName.equals(channel.getName())) continue;
                    String channelProtocol = channel.getProtocol();
                    if (serverPort.getProtocol().equals(channelProtocol)) {
                        String channelHost = channel.getListenAddress();
                        if (channelHost == null) {
                            channelHost = this.getLocalHost();
                        }
                        int channelPort = channel.getListenPort();
                        return new Port(serverPort.getProtocol(), channelHost, channelPort, this, null, false);
                    }
                    return null;
                }
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("UnknownHostException: " + e.getMessage());
        }
        return serverPort;
    }

    private Port getVirtualTargetPort(VirtualTargetMBean vtMBean, Port serverPort) {
        try {
            String[] hs = vtMBean.getHostNames();
            if (hs != null && hs.length > 0) {
                String uriPrefix;
                String bestHostName = hs[0];
                if (bestHostName.indexOf("localhost") <= -1 && bestHostName.indexOf(".") <= -1) {
                    for (String toBeBest : hs) {
                        if (toBeBest.indexOf(".") <= -1 || !toBeBest.startsWith(bestHostName)) continue;
                        bestHostName = toBeBest;
                    }
                }
                if ((uriPrefix = vtMBean.getUriPrefix()) != null && uriPrefix.trim().length() > 0) {
                    if (uriPrefix.startsWith("/")) {
                        uriPrefix = uriPrefix.substring(1);
                    }
                    return new Port(serverPort.getProtocol(), bestHostName, serverPort.getPort(), this, uriPrefix.trim(), false);
                }
                return new Port(serverPort.getProtocol(), bestHostName, serverPort.getPort(), this, null, false);
            }
            String listenUrl = PartitionUtils.getVirtualTargetListenURL((VirtualTargetMBean)vtMBean, (String)this.serverName, (String)serverPort.getProtocol());
            if (listenUrl != null) {
                return new Port(listenUrl, this);
            }
            String uriPrefix = vtMBean.getUriPrefix();
            if (uriPrefix != null && uriPrefix.trim().length() > 0) {
                return new Port(serverPort.getProtocol(), serverPort.getHost(), serverPort.getPort(), this, uriPrefix.trim(), false);
            }
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("UnknownHostException: " + e.getMessage());
        }
        catch (PortabilityLayerException e) {
            throw new RuntimeException("PortabilityLayerException: " + e.getMessage());
        }
        return serverPort;
    }
}

