/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrf.wls;

import java.io.Serializable;
import oracle.jrf.Application;

public class ApplicationImpl
extends Application
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String applicationName;
    private final String partitionName;
    private final String version;
    private final String deploymentName;
    private final String applicationId;
    private final String configuredDeploymentName;
    private final String configuredVersion;

    protected ApplicationImpl(String appName, String version, String partitionName) {
        this.version = version;
        this.partitionName = partitionName;
        if (partitionName != null && partitionName.trim().length() > 0) {
            if (version != null && version.trim().length() > 0) {
                this.deploymentName = appName + "#" + version;
                this.applicationId = appName + "#" + version + "$" + partitionName;
                this.applicationName = appName;
            } else {
                this.applicationName = appName;
                this.deploymentName = appName;
                this.applicationId = appName + "$" + partitionName;
            }
        } else if (version != null && version.trim().length() > 0) {
            this.applicationId = appName + "#" + version;
            this.applicationName = appName;
            this.deploymentName = appName + "#" + version;
        } else {
            this.applicationId = appName;
            this.applicationName = appName;
            this.deploymentName = appName;
        }
        this.configuredDeploymentName = this.deploymentName;
        this.configuredVersion = this.version;
    }

    protected ApplicationImpl(String appName, String version, String partitionName, String cfgDepName) {
        this.version = version;
        this.partitionName = partitionName;
        if (partitionName != null && partitionName.trim().length() > 0) {
            if (version != null && version.trim().length() > 0) {
                this.deploymentName = appName + "#" + version;
                this.applicationId = appName + "#" + version + "$" + partitionName;
                this.applicationName = appName;
            } else {
                this.applicationName = appName;
                this.deploymentName = appName;
                this.applicationId = appName + "$" + partitionName;
            }
        } else if (version != null && version.trim().length() > 0) {
            this.applicationId = appName + "#" + version;
            this.applicationName = appName;
            this.deploymentName = appName + "#" + version;
        } else {
            this.applicationId = appName;
            this.applicationName = appName;
            this.deploymentName = appName;
        }
        String cfgDeploymentName = this.deploymentName;
        String cfgVersion = this.version;
        if (cfgDepName != null) {
            cfgDeploymentName = cfgDepName;
            if (cfgDeploymentName.equals(this.applicationName)) {
                cfgVersion = null;
            } else {
                int index = cfgDeploymentName.indexOf("#");
                int length = cfgDeploymentName.length();
                if (index > 0 && length > index) {
                    cfgVersion = cfgDeploymentName.substring(index + 1, length);
                }
            }
        }
        this.configuredDeploymentName = cfgDeploymentName;
        this.configuredVersion = cfgVersion;
    }

    @Override
    public String getConfiguredDeploymentName() {
        return this.configuredDeploymentName;
    }

    @Override
    public String getConfiguredVersion() {
        return this.configuredVersion;
    }

    @Override
    public String getDeploymentName() {
        return this.deploymentName;
    }

    @Override
    public String getApplicationId() {
        return this.applicationId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public String getPartitionName() {
        return this.partitionName;
    }
}

