/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import javax.swing.Action;
import javax.swing.SwingUtilities;
import oracle.bali.share.nls.StringUtils;

public final class JdevIdeUtils {
    public static void setActionName(final Action action, final String newName) {
        if (action == null) {
            throw new IllegalArgumentException("Argument action must not be null");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Argument newName must not be null");
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String oldName = (String)action.getValue("Name");
                if (newName.equals(oldName)) {
                    return;
                }
                int mnemonicIndex = StringUtils.getMnemonicIndex((String)newName);
                String strippedNewName = StringUtils.stripMnemonic((String)newName);
                action.putValue("Name", strippedNewName);
                if (mnemonicIndex != -1) {
                    action.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)newName));
                }
            }
        };
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    private JdevIdeUtils() {
    }
}

