/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.text.DefaultCaret;
import oracle.bm.util.ui.table.CellUtils;

public class ListEditor
extends AbstractCellEditor
implements TableCellEditor,
KeyListener {
    private final JPanel m_wrapperPanel = new WrapperPanel();
    private final Runnable m_stopEditingLater = new Runnable(){

        @Override
        public void run() {
            ListEditor.this.stopCellEditing();
        }
    };
    private final JComboBox m_comboBox;

    public ListEditor(JComboBox comboBox) {
        if (comboBox == null) {
            throw new IllegalArgumentException("Missing combo box for editor");
        }
        this.m_comboBox = comboBox;
        this.m_comboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.m_comboBox.putClientProperty("JComboBox.lightweightKeyboardNavigation", "Lightweight");
        this.m_wrapperPanel.setLayout(new BorderLayout());
        this.m_wrapperPanel.setOpaque(true);
        this.m_wrapperPanel.add((Component)this.m_comboBox, "Center");
        this.m_wrapperPanel.setInputMap(0, this.m_comboBox.getInputMap());
        this.m_wrapperPanel.setInputMap(1, this.m_comboBox.getInputMap(1));
        this.m_wrapperPanel.setActionMap(this.m_comboBox.getActionMap());
        if (comboBox.isEditable()) {
            Component c = comboBox.getEditor().getEditorComponent();
            if (c instanceof JTextField) {
                ((JTextField)c).setCaret(new DefaultCaret());
            }
            c.addKeyListener(this);
        } else {
            comboBox.addKeyListener(this);
        }
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_comboBox.getSelectedItem();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        CellUtils.setUpEditor(this.m_comboBox, table);
        this.setValue(this.m_comboBox, value);
        this.m_comboBox.hidePopup();
        if (this.m_comboBox.isEditable()) {
            Component c = this.m_comboBox.getEditor().getEditorComponent();
            if (c instanceof JTextField) {
                ((JTextField)c).selectAll();
            }
            if (c instanceof JComponent) {
                ((JComponent)c).setBorder(null);
            }
            for (int i = this.m_comboBox.getComponentCount() - 1; i >= 0; --i) {
                Component b = this.m_comboBox.getComponent(i);
                if (!(b instanceof JButton)) continue;
                Color f = table.getForeground();
                ((JButton)b).setBorder(new LineBorder(new Color(f.getRed(), f.getGreen(), f.getBlue(), 127)));
            }
        }
        return this.m_wrapperPanel;
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        if (event.getKeyCode() == 10 && !this.m_comboBox.getUI().isPopupVisible(this.m_comboBox)) {
            event.consume();
            this.stopCellEditing();
        }
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    protected void setValue(Component component, Object value) {
        ((JComboBox)component).setSelectedItem(value);
    }

    private class WrapperPanel
    extends JPanel {
        private WrapperPanel() {
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void requestFocus() {
            ListEditor.this.m_comboBox.requestFocus();
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            Component comp = ListEditor.this.m_comboBox;
            if (ListEditor.this.m_comboBox.isEditable()) {
                comp = ListEditor.this.m_comboBox.getEditor().getEditorComponent();
            }
            return CellUtils.processKeyBinding(comp, ks, e, condition, pressed);
        }
    }
}

