/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class MultipleImageIcon
extends ImageIcon {
    private Collection m_icons;
    private int m_width = -1;
    private int m_height = -1;

    public MultipleImageIcon(Icon lower, Icon upper) {
        this.m_icons = new ArrayList();
        this.m_icons.add(lower);
        this.m_icons.add(upper);
        this.createImage();
    }

    public MultipleImageIcon(Collection icons) {
        this.m_icons = icons;
        this.createImage();
    }

    private void createImage() {
        this.calculateWidthAndHeight();
        BufferedImage bi = new BufferedImage(this.m_width, this.m_height, 2);
        this.paintIntoImage(bi.createGraphics(), 0, 0);
        this.setImage(bi);
    }

    private void calculateWidthAndHeight() {
        for (Icon icon : this.m_icons) {
            if (icon.getIconWidth() > this.m_width) {
                this.m_width = icon.getIconWidth();
            }
            if (icon.getIconHeight() <= this.m_height) continue;
            this.m_height = icon.getIconHeight();
        }
    }

    private void paintIntoImage(Graphics g, int x, int y) {
        for (Icon icon : this.m_icons) {
            icon.paintIcon(null, g, x, y);
        }
    }
}

