/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util.ui;

import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LimitedLengthDocument
extends PlainDocument {
    private final int m_maxLength;

    public LimitedLengthDocument(int maxLength) {
        if (maxLength <= 0) {
            throw new IllegalArgumentException("Illegal length: " + maxLength);
        }
        this.m_maxLength = maxLength;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            str = "";
        }
        if (this.getLength() + str.length() <= this.m_maxLength) {
            super.insertString(offs, str, a);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

