/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util;

import java.net.URL;
import java.net.URLEncoder;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.Preferences;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;

public abstract class URLUtil {
    public static String toRelativePath(URL url, URLPath base) {
        return URLUtil.toRelativePath(url, base, null);
    }

    public static String toRelativePath(URL url, URLPath base, URL[] baseUsed) {
        if (baseUsed != null) {
            baseUsed[0] = null;
        }
        URL[] entries = base.getEntries();
        String[] matches = new String[entries.length];
        boolean matched = false;
        for (int i = 0; i < entries.length; ++i) {
            String relative = URLFileSystem.toRelativeSpec((URL)url, (URL)entries[i]);
            if (relative == null) continue;
            matches[i] = relative;
            matched = true;
        }
        if (!matched) {
            return null;
        }
        int minLength = 0;
        int minIndex = -1;
        for (int i = 0; i < matches.length; ++i) {
            int tempLength;
            if (matches[i] == null || (tempLength = matches[i].length()) >= minLength && minIndex != -1) continue;
            minLength = tempLength;
            minIndex = i;
        }
        if (baseUsed != null) {
            baseUsed[0] = entries[minIndex];
        }
        return matches[minIndex];
    }

    public static String getSuffixSansExtras(URL url) {
        String before = URLFileSystem.getSuffix((URL)url);
        String after = URLUtil.getSuffixSansExtrasFromNaiveSuffix(before);
        return after;
    }

    public static String getSuffixSansExtras(String path) {
        int index = path.lastIndexOf(46);
        if (index != -1) {
            return URLUtil.getSuffixSansExtrasFromNaiveSuffix(path.substring(index, path.length()));
        }
        return "";
    }

    private static String getSuffixSansExtrasFromNaiveSuffix(String suffixAndReportedByFileSystem) {
        int cutIndex = URLUtil.hashNMarkIndex(suffixAndReportedByFileSystem);
        if (cutIndex != -1) {
            return suffixAndReportedByFileSystem.substring(0, cutIndex);
        }
        return suffixAndReportedByFileSystem;
    }

    private static int hashNMarkIndex(String path) {
        int hashIndex = path.indexOf(35);
        int questionIndex = path.indexOf(63);
        if (hashIndex != -1) {
            if (questionIndex != -1) {
                return Math.min(hashIndex, questionIndex);
            }
            return hashIndex;
        }
        if (questionIndex != -1) {
            return questionIndex;
        }
        return -1;
    }

    public static String appendSuffix(String path, String extension) {
        int hashIndex = URLUtil.hashNMarkIndex(path);
        if (hashIndex != -1) {
            return path.substring(0, hashIndex) + extension + path.substring(hashIndex, path.length());
        }
        return path + extension;
    }

    public static String encodeURLPath(String relative) {
        EnvironOptions environOptions = EnvironOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        String encoding = environOptions.getEncoding();
        return URLUtil.encodeURLPath(relative, encoding != null ? encoding : System.getProperty("file.encoding"));
    }

    public static String encodeURLPath(String relative, String encoding) {
        try {
            String encoded = URLEncoder.encode(relative, encoding);
            String fixSlashes = encoded.replaceAll("%2F", "/");
            String fixHashes = fixSlashes.replaceAll("%23", "#");
            String fixSpaces = fixHashes.replaceAll("\\+", "%20");
            String fixColon = fixSpaces.replaceAll("%3A", ":");
            return fixColon;
        }
        catch (Exception e) {
            return relative;
        }
    }
}

