/*
 * Decompiled with CFR 0.152.
 */
package oracle.bm.util;

import java.awt.Component;
import java.awt.Graphics;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bm.util.IconLoader;

public final class IconCache {
    private static final int s_INITIAL_CAPACITY = 256;
    private static final IconCache s_INSTANCE = new IconCache(341);
    private static final Icon s_NULL_ICON = new Icon(){

        @Override
        public int getIconHeight() {
            return 0;
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }
    };
    private static final IconLoader s_DEFAULT_LOADER = new IconLoader(){

        @Override
        public Icon loadIcon(URL url) {
            return new ImageIcon(url);
        }
    };
    private final Map m_iconByURL;

    public static IconCache getInstance() {
        return s_INSTANCE;
    }

    private IconCache(int initialCapacity) {
        this.m_iconByURL = new HashMap(initialCapacity);
    }

    public synchronized Icon getIcon(URL url) {
        return this.getIcon(url, s_DEFAULT_LOADER);
    }

    public synchronized Icon getIcon(URL url, IconLoader loader) {
        if (url == null) {
            throw new IllegalArgumentException("url must not be null");
        }
        if (loader == null) {
            throw new IllegalArgumentException("loader must not be null");
        }
        Icon icon = (Icon)this.m_iconByURL.get(url);
        if (icon == s_NULL_ICON) {
            return null;
        }
        if (icon != null) {
            return icon;
        }
        icon = loader.loadIcon(url);
        this.m_iconByURL.put(url, icon == null ? s_NULL_ICON : icon);
        return icon;
    }
}

