/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.event.ChangeListener;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Assert;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdevimpl.deploy.res.StripeArb;
import oracle.jdevimpl.deploy.stripe.InputStreamProvider;
import oracle.jdevimpl.deploy.stripe.MonitoredInputStream;
import oracle.jdevimpl.deploy.stripe.MonitoredOutputStream;
import oracle.jdevimpl.deploy.stripe.MonitoredStream;
import oracle.jdevimpl.deploy.stripe.OutputStreamProvider;
import oracle.jdevimpl.deploy.stripe.StreamProvider;
import oracle.jdevimpl.deploy.stripe.StreamProviderFactory;
import oracle.jdevimpl.deploy.stripe.URLInputStreamProvider;
import oracle.jdevimpl.deploy.stripe.URLOutputStreamProvider;

public class URLStreamProviderFactory
extends StreamProviderFactory {
    @Override
    InputStreamProvider createInputProvider(OutputStreamProvider provider) {
        if (provider instanceof URLOutputStreamProvider) {
            URLOutputStreamProvider output = (URLOutputStreamProvider)provider;
            return new FileInputStreamProvider(output);
        }
        return super.createInputProvider(provider);
    }

    @Override
    OutputStreamProvider createTempOutputProvider(ArchiveEntry entry) {
        return new FileOutputStreamProvider(entry);
    }

    @Override
    OutputStreamProvider createOriginalReadOnlyProvider(ArchiveEntry entry) {
        return new ReadOnlyOutputStreamProvider(entry);
    }

    static class NullInputStream
    extends ByteArrayInputStream {
        NullInputStream() {
            super(new byte[0], 0, 0);
        }
    }

    static class ReadOnlyOutputStreamProvider
    extends FileOutputStreamProvider {
        ReadOnlyOutputStreamProvider(ArchiveEntry entry) {
            super(entry, entry.getURL(), false);
        }

        @Override
        public MonitoredOutputStream getOutputStream() throws IOException {
            throw new IOException(StripeArb.getString(3));
        }
    }

    static class FileOutputStreamProvider
    extends AbstractOutputStreamProvider
    implements URLOutputStreamProvider {
        URL fileURL_ = null;
        final boolean deleteOnRelease_;

        FileOutputStreamProvider(ArchiveEntry entry) {
            this(entry, null, true);
        }

        FileOutputStreamProvider(ArchiveEntry entry, URL url, boolean deleteOnRelease) {
            super(entry);
            this.deleteOnRelease_ = deleteOnRelease;
            this.fileURL_ = url;
        }

        @Override
        public MonitoredOutputStream getOutputStream() throws IOException {
            if (this.stream_.getStatus() == 0) {
                if (this.fileURL_ == null) {
                    String entryName = this.getEntry().getName();
                    String prefix = entryName.replaceAll("\\/", "_").replaceAll("\\.", "_");
                    this.fileURL_ = URLFileSystem.createTempFile((String)prefix, (String)".tmp", null);
                    Assert.println((String)("Temporary file created " + this.fileURL_.toExternalForm()));
                }
                this.stream_.setStreamAndStatus(URLFileSystem.openOutputStream((URL)this.fileURL_), 1);
            }
            return this.stream_;
        }

        @Override
        public InputStream getRawInputStream() throws IOException {
            if (this.fileURL_ != null) {
                return URLFileSystem.openInputStream((URL)this.fileURL_);
            }
            return new NullInputStream();
        }

        @Override
        public void releaseImpl() throws IOException {
            Assert.println((String)("OutputStream released. URL:" + (this.fileURL_ != null ? this.fileURL_.toExternalForm() : "null")));
            if (this.fileURL_ != null && this.deleteOnRelease_) {
                if (URLFileSystem.delete((URL)this.fileURL_)) {
                    Assert.println((String)("Deleted " + this.fileURL_.toExternalForm()));
                    this.fileURL_ = null;
                } else {
                    Assert.println((String)("File could not be deleted. " + this.fileURL_.toExternalForm()));
                }
            }
        }

        @Override
        public URL getURL() {
            Assert.check((this.fileURL_ != null ? 1 : 0) != 0, (String)"Cannot determine URL, OutputStream not opened yet");
            return this.fileURL_;
        }

        @Override
        public void copyTo(URL url) throws IOException {
            if (this.fileURL_ == null) {
                throw new MalformedURLException(StripeArb.getString(2));
            }
            URLFileSystem.copy((URL)this.fileURL_, (URL)url);
        }

        @Override
        void closeStream() throws IOException {
            this.stream_.close();
        }
    }

    static class FileInputStreamProvider
    extends AbstractInputStreamProvider
    implements URLInputStreamProvider {
        FileInputStreamProvider(URLOutputStreamProvider output) {
            super(output);
        }

        @Override
        public MonitoredInputStream getInputStream() throws IOException {
            if (this.stream_.getStatus() == 0) {
                InputStream input = this.output_.getRawInputStream();
                this.stream_.setStreamAndStatus(input, 1);
            }
            return this.stream_;
        }

        @Override
        public URL getURL() {
            return ((URLOutputStreamProvider)this.output_).getURL();
        }

        @Override
        public void copyTo(URL url) throws IOException {
            URLFileSystem.copy((URL)this.getURL(), (URL)url);
        }

        @Override
        void closeStream() throws IOException {
            this.stream_.close();
        }
    }

    static abstract class AbstractOutputStreamProvider
    extends AbstractStreamProvider
    implements OutputStreamProvider {
        protected final MonitoredOutputStream stream_ = new MonitoredOutputStream();

        AbstractOutputStreamProvider(ArchiveEntry entry) {
            super(entry);
        }

        @Override
        MonitoredStream getStream() {
            return this.stream_;
        }

        @Override
        public boolean isDirty() {
            return this.stream_.isDirty();
        }
    }

    static abstract class AbstractInputStreamProvider
    extends AbstractStreamProvider
    implements InputStreamProvider {
        protected final OutputStreamProvider output_;
        protected final MonitoredInputStream stream_;

        AbstractInputStreamProvider(OutputStreamProvider output) {
            super(output.getEntry());
            this.output_ = output;
            this.stream_ = new MonitoredInputStream();
        }

        @Override
        MonitoredStream getStream() {
            return this.stream_;
        }

        @Override
        public boolean isDirty() {
            return this.stream_.isDirty();
        }
    }

    static abstract class AbstractStreamProvider
    implements StreamProvider {
        protected final ArchiveEntry entry_;

        AbstractStreamProvider(ArchiveEntry entry) {
            this.entry_ = entry;
        }

        @Override
        public ArchiveEntry getEntry() {
            return this.entry_;
        }

        @Override
        public void release() throws IOException {
            this.releaseImpl();
        }

        protected void releaseImpl() throws IOException {
            this.closeStream();
        }

        @Override
        public int getStatus() {
            return this.getStream().getStatus();
        }

        @Override
        public void addChangeListener(ChangeListener listener) {
            this.getStream().addChangeListener(listener);
        }

        @Override
        public void removeChangeListener(ChangeListener listener) {
            this.getStream().removeChangeListener(listener);
        }

        abstract MonitoredStream getStream();

        abstract void closeStream() throws IOException;
    }
}

