/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.stripe;

import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeploymentModule;
import oracle.jdeveloper.deploy.DeploymentModuleFactory;
import oracle.jdeveloper.deploy.common.ModuleContext;
import oracle.jdeveloper.deploy.meta.MetadataException;
import oracle.jdeveloper.deploy.meta.UpgradableStore;
import oracle.jdeveloper.deploy.meta.pattern.ChainOfR;

public class DeploymentModuleFactoryStore
implements DeploymentModuleFactory {
    UpgradableStore<String, DeploymentModuleFactory, RequestCookie> impl_ = new UpgradableStore(new ModuleHandler());
    private static DeploymentModuleFactoryStore instance_ = null;

    public static synchronized DeploymentModuleFactoryStore getInstance() {
        if (instance_ == null) {
            instance_ = new DeploymentModuleFactoryStore();
        }
        return instance_;
    }

    private DeploymentModule createModule(Class<?> classElem, ModuleContext context) throws Exception {
        RequestCookie cookie = new RequestCookie(classElem, context);
        while (classElem != null) {
            block4: {
                try {
                    if (this.impl_.handle(classElem.getName(), cookie)) {
                        break;
                    }
                }
                catch (ChainOfR.IndexNotFoundException e) {
                    if (classElem.getSuperclass() != null) break block4;
                    throw e;
                }
            }
            classElem = classElem.getSuperclass();
        }
        return cookie.module;
    }

    @Override
    public DeploymentModule create(Class<?> clazz, ModuleContext context) throws DeployException {
        DeploymentModule depMod = null;
        try {
            depMod = this.createModule(clazz, context);
        }
        catch (DeployException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DeployException(e);
        }
        return depMod;
    }

    public void addFactory(String className, DeploymentModuleFactory factory) throws MetadataException {
        try {
            this.impl_.addNode(className, factory);
        }
        catch (ChainOfR.DuplicateIndexException e) {
            throw new MetadataException("A DeploymentModuleFactory already exists for this class, use upgradeFactory() instead.");
        }
        catch (MetadataException e) {
            throw new MetadataException("Cannot add factory, a valid class argument is required");
        }
    }

    public void upgradeFactory(String className, DeploymentModuleFactory factory) throws MetadataException {
        try {
            this.impl_.upgradeNode(className, factory);
        }
        catch (ChainOfR.IndexNotFoundException e) {
            throw new MetadataException("Cannot upgrade. Class " + className + " not registered yet");
        }
    }

    class ModuleHandler
    implements UpgradableStore.Handler<DeploymentModuleFactory, RequestCookie> {
        ModuleHandler() {
        }

        @Override
        public boolean handle(DeploymentModuleFactory factory, RequestCookie request) throws DeployException {
            request.module = factory.create(request.clazz, request.context);
            return request.module != null;
        }
    }

    class RequestCookie {
        final ModuleContext context;
        final Class<?> clazz;
        DeploymentModule module;

        RequestCookie(Class<?> classElem, ModuleContext context) {
            this.context = context;
            this.clazz = classElem;
        }
    }
}

