/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.spi.profilesupport;

import javax.ide.util.MetaClass;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.ProfileStorage;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileHashIO;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileInfo;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileSupport;
import oracle.jdeveloper.deploy.spi.providers.AbstractHashProfileIOProvider;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;
import oracle.jdevimpl.deploy.spi.profilesupport.PS;

public class PSHashProfileIOProvider
extends AbstractHashProfileIOProvider {
    final PS ps;
    ProfileHashIO io;
    boolean ioInitialized = false;

    PSHashProfileIOProvider(ProfileSupport profileSupport) {
        this.ps = new PS(profileSupport);
    }

    PSHashProfileIOProvider(MetaClass<ProfileSupport> profileSupportClass) {
        this.ps = new PS(profileSupportClass);
    }

    @Override
    protected boolean canRead(Element element, HashStructure hash, ToolkitContext tkContext, Cookie cookie) {
        ProfileInfo info = this.ps.getProfileInfo();
        if (info == null) {
            return false;
        }
        String idInHash = hash.getString(Profile.PROFILE_CLASS_NAME);
        String profileId = info.getId();
        assert (profileId != null);
        if (profileId.equals(idInHash) && this.getHashIO() != null) {
            DataContainer dc = null;
            if (element instanceof DataContainer) {
                dc = (DataContainer)element;
            } else if (element instanceof ProfileStorage) {
                ProfileStorage ps = (ProfileStorage)element;
                dc = ps.getDataContainer();
            }
            if (dc != null) {
                cookie.bind(ToolkitContext.class, tkContext);
                cookie.bind(DataContainer.class, dc);
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean canWrite(Element element, Profile profile, ToolkitContext tkContext, Cookie cookie) {
        Class<?> profileClass = profile.getClass();
        if (profileClass.getName().equals(this.ps.getProfileClassName()) && this.ps.getProfileClass() == profileClass && this.getHashIO() != null) {
            cookie.bind(ToolkitContext.class, tkContext);
            return true;
        }
        return false;
    }

    @Override
    protected Profile read(Element element, HashStructure hash, Cookie cookie) {
        ProfileHashIO io = this.getHashIO();
        DataContainer dataContainer = cookie.get(DataContainer.class);
        ToolkitContext tkContext = cookie.get(ToolkitContext.class);
        assert (io != null);
        assert (hash.containsKey(Profile.PROFILE_CLASS_NAME));
        HashStructure sanitized = hash.copyTo(HashStructure.newInstance());
        sanitized.remove(Profile.PROFILE_CLASS_NAME);
        return io.create(sanitized, dataContainer, tkContext.getIdeContext());
    }

    @Override
    protected String getName(Element element, HashStructure hash, Cookie cookie) {
        ProfileHashIO io = this.getHashIO();
        assert (io != null);
        return io.getName(hash);
    }

    @Override
    protected void write(Element element, Profile profile, HashStructure hash, Cookie cookie) {
        ProfileHashIO io = this.getHashIO();
        String id = this.ps.getProfileInfo().getId();
        ToolkitContext tkContext = cookie.get(ToolkitContext.class);
        assert (io != null);
        HashStructure toHash = io.toHashStructure(profile, element, tkContext.getIdeContext());
        toHash.copyTo(hash);
        hash.putString(Profile.PROFILE_CLASS_NAME, id);
    }

    private synchronized ProfileHashIO getHashIO() {
        if (this.io == null) {
            ProfileSupport support = this.ps.getProfileSupport();
            this.io = support.getHashIO();
        }
        return this.io;
    }
}

