/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.spi.profilesupport;

import javax.ide.util.MetaClass;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.ide.util.ClassUtils;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.spi.profilesupport.CommandFactory;
import oracle.jdeveloper.deploy.spi.profilesupport.ProfileSupport;
import oracle.jdeveloper.deploy.spi.providers.AbstractCommandFactoryProvider;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;
import oracle.jdevimpl.deploy.spi.profilesupport.PS;

public class PSCommandFactoryProvider
extends AbstractCommandFactoryProvider {
    final PS ps;

    PSCommandFactoryProvider(ProfileSupport profileSupport) {
        this.ps = new PS(profileSupport);
    }

    PSCommandFactoryProvider(MetaClass<ProfileSupport> profileSupportClass) {
        this.ps = new PS(profileSupportClass);
    }

    @Override
    protected boolean canCreate(Object command, Element element, ToolkitContext context, Cookie cookie) {
        String profileClassName = this.ps.getProfileClassName();
        assert (profileClassName != null);
        boolean ret = ClassUtils.isInstanceOf(element.getClass(), (String)profileClassName);
        if (!ret) {
            return false;
        }
        CommandFactory cf = this.getCommandFactory();
        if (cf == null) {
            return false;
        }
        Class<Profile> profileClass = this.ps.getProfileClass();
        if (!profileClass.isAssignableFrom(element.getClass())) {
            return false;
        }
        cookie.bind(CommandFactory.class, cf);
        cookie.bind(Context.class, context.getIdeContext());
        cookie.bind(Profile.class, element);
        return ret;
    }

    @Override
    protected DeployCommand createCommand(Object command, Cookie cookie) {
        CommandFactory cf = cookie.get(CommandFactory.class);
        Context ctx = cookie.get(Context.class);
        Profile profile = cookie.get(Profile.class);
        return cf.create(command, profile, ctx);
    }

    private CommandFactory getCommandFactory() {
        return this.ps.getProfileSupport().getCommandFactory();
    }
}

