/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.spi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.ToolkitFactory;
import oracle.jdeveloper.deploy.spi.Cookie;
import oracle.jdeveloper.deploy.spi.HashDependableReader;
import oracle.jdeveloper.deploy.spi.HashDependableWriter;
import oracle.jdeveloper.deploy.spi.providers.AbstractDependableIOProvider;
import oracle.jdeveloper.deploy.tk.ToolkitBuilder;
import oracle.jdeveloper.deploy.tk.ToolkitRegistry;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;

public class LegacyDependableIOProvider
extends AbstractDependableIOProvider {
    static final String LEGACY_DATA_KEY = "dependencies";
    static final String LEGACY_DEPENDENCY_LIST_KEY = "dependencyList";

    HashStructure getHashStructure(Element element) {
        HashStructure possibleHash = null;
        if (element instanceof Profile) {
            possibleHash = ((Profile)element).getHashStructure();
        }
        return possibleHash;
    }

    synchronized HashStructure getDependencies(Element element, boolean create) {
        HashStructure hash = this.getHashStructure(element);
        if (hash == null) {
            return null;
        }
        if (create) {
            return hash.getOrCreateHashStructure(LEGACY_DATA_KEY);
        }
        return hash.getHashStructure(LEGACY_DATA_KEY);
    }

    synchronized ListStructure getDependablesList(Element element, boolean create) {
        HashStructure hash = this.getDependencies(element, create);
        if (hash == null) {
            return null;
        }
        if (create) {
            return hash.getOrCreateListStructure(LEGACY_DEPENDENCY_LIST_KEY);
        }
        return hash.getListStructure(LEGACY_DEPENDENCY_LIST_KEY);
    }

    @Override
    protected boolean canRead(Element element, ToolkitContext context, Cookie cookie) {
        if (this.getHashStructure(element) != null) {
            cookie.bind(Context.class, context.getIdeContext());
            return true;
        }
        return false;
    }

    @Override
    protected boolean canWrite(Element element, ToolkitContext context, Cookie cookie) {
        if (this.getHashStructure(element) != null) {
            cookie.bind(Context.class, context.getIdeContext());
            return true;
        }
        return false;
    }

    @Override
    protected Iterator<Dependable> iterator(Element element, Cookie cookie) {
        ListStructure hash = this.getDependablesList(element, false);
        if (hash == null) {
            return Collections.emptyList().iterator();
        }
        Context context = cookie.get(Context.class);
        return new DependableIterator(new HashDependableReaderIterator(hash, element, context));
    }

    @Override
    protected List<Dependable> getAllDependables(Element element, Cookie cookie) {
        ArrayList<Dependable> list = new ArrayList<Dependable>();
        Iterator<Dependable> iter = this.iterator(element, cookie);
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    @Override
    protected boolean remove(Dependable dependable, Element element, Cookie cookie) {
        Iterator<Dependable> iter = this.iterator(element, cookie);
        while (iter.hasNext()) {
            Dependable p = iter.next();
            if (!dependable.equals(p)) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    @Override
    protected void removeAll(Element element, Cookie cookie) {
        Iterator<Dependable> iter = this.iterator(element, cookie);
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Override
    protected boolean write(Dependable dependable, Element element, Cookie cookie) {
        Context ideContext = cookie.get(Context.class);
        HashDependableWriter.SpiData spi = HashDependableWriter.SpiData.getInstance(ideContext);
        spi.setDependable(dependable);
        ToolkitRegistry reg = ToolkitRegistry.getInstance();
        ToolkitBuilder builder = reg.getBuilder(element, ideContext, HashDependableWriter.class);
        HashDependableWriter writer = (HashDependableWriter)builder.narrowBuildToolkits()[0];
        HashStructure hash = HashStructure.newInstance();
        writer.write(hash);
        ListStructure list = this.getDependablesList(element, true);
        list.add((Object)hash);
        return true;
    }

    static class DependableIterator
    implements Iterator<Dependable> {
        final Iterator<HashDependableReader> iter;

        DependableIterator(Iterator<HashDependableReader> iter) {
            this.iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Dependable next() {
            return this.iter.next().read();
        }

        @Override
        public void remove() {
            this.iter.remove();
        }
    }

    static class HashDependableReaderIterator
    implements ToolkitFactory,
    Iterator<HashDependableReader> {
        final Iterator iter;
        final ListStructure dependablesList;
        final Element element;
        final Context ideContext;

        HashDependableReaderIterator(ListStructure dependablesList, Element element, Context ideContext) {
            assert (dependablesList != null);
            this.dependablesList = dependablesList;
            this.iter = dependablesList.iterator();
            this.element = element;
            this.ideContext = ideContext;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public HashDependableReader next() {
            HashStructure hash = (HashStructure)this.iter.next();
            return this.getReader(hash);
        }

        @Override
        public void remove() {
            this.iter.remove();
        }

        private HashDependableReader getReader(HashStructure hash) {
            Context context = new Context(this.ideContext);
            HashDependableReader.SpiData spi = HashDependableReader.SpiData.getInstance(context);
            spi.setHashStructure(hash);
            HashDependableReader reader = ToolkitFactory.Utils.narrowBuildFirst(this.element, context, HashDependableReader.class);
            return reader;
        }
    }
}

