/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.jdeveloper.deploy.DependencyConfiguration;
import oracle.jdeveloper.deploy.DependencyStorage;

public class DependableContainer {
    private List<Dependable> _dependencyList = null;

    public DependableContainer() {
    }

    public DependableContainer(DependableContainer copy) {
        if (copy._dependencyList != null) {
            this._dependencyList = new ArrayList<Dependable>(copy._dependencyList);
        }
    }

    private synchronized List<Dependable> dependencyList(DependencyStorage storage) {
        if (this._dependencyList == null) {
            this._dependencyList = new ArrayList<Dependable>();
            Context ctx = new Context(storage instanceof Element ? (Element)storage : null);
            DependencyConfiguration dc = DependencyConfiguration.getInstance(storage, ctx);
            Collections.addAll(this._dependencyList, dc.getDependables());
        }
        return this._dependencyList;
    }

    public Iterator<Dependable> getDependencies(DependencyStorage storage) {
        return Collections.unmodifiableList(this.dependencyList(storage)).iterator();
    }

    public synchronized void addDependency(DependencyStorage storage, Dependable dependable) {
        if (this.dependencyList(storage).contains(dependable)) {
            this.removeDependency(storage, dependable);
        }
        Context ctx = new Context(storage instanceof Element ? (Element)storage : null);
        DependencyConfiguration dc = DependencyConfiguration.getInstance(storage, ctx);
        dc.add(dependable);
        this.dependencyList(storage).add(dependable);
    }

    public synchronized Dependable removeDependency(DependencyStorage storage, Dependable dependable) {
        Context ctx = new Context(storage instanceof Element ? (Element)storage : null);
        DependencyConfiguration dc = DependencyConfiguration.getInstance(storage, ctx);
        boolean removedFromHash = dc.remove(dependable);
        boolean removedFromList = this.dependencyList(storage).remove(dependable);
        assert (removedFromHash && removedFromList || !removedFromHash && !removedFromList);
        return removedFromHash ? dependable : null;
    }

    public Iterator<Dependable> iterator(DependencyStorage storage) {
        return Collections.unmodifiableList(this.dependencyList(storage)).iterator();
    }

    public DependableContainer copyTo(DependableContainer o) {
        if (o == null) {
            o = new DependableContainer(this);
            return o;
        }
        o._dependencyList = this._dependencyList == null ? null : new ArrayList<Dependable>(this._dependencyList);
        return o;
    }
}

