/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import oracle.ide.migration.ExtensionMigrator;
import oracle.javatools.data.HashStructure;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeploymentOptions;
import org.w3c.dom.Element;

public class DeploymentOptionsMigrator
extends ExtensionMigrator {
    protected List getSettingKeys() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("deployment-options");
        return list;
    }

    protected String getExtensionID() {
        return "oracle.deploy.core";
    }

    protected ClassLoader getMigratorClassLoader() {
        return DeploymentOptions.class.getClassLoader();
    }

    protected Class loadClass(Element element) throws ClassNotFoundException {
        String className = element.getAttribute("class");
        if (className.equals("oracle.jdeveloper.deploy.dt.DeploymentOptions")) {
            element.setAttribute("class", "oracle.jdevimpl.deploy.DeploymentOptionsMigrator$DeprecatedDeploymentOptions");
            return DeprecatedDeploymentOptions.class;
        }
        throw new ClassNotFoundException("ClassName : " + className + " not found.");
    }

    protected File getSourceFile(File sourceDir) {
        return this.getSourceFileOrJDevExtrasFile(sourceDir);
    }

    protected boolean addToProductPreferences() {
        return true;
    }

    protected ExtensionMigrator.AdjustedObject[] adjustObject(String inKey, Object inObject) {
        DeprecatedDeploymentOptions old = (DeprecatedDeploymentOptions)inObject;
        DeploymentOptions newOpts = new DeploymentOptions(HashStructure.newInstance());
        newOpts.setApplicationAbsoluteOutputURL(old.getApplicationAbsoluteOutputURL());
        newOpts.setApplicationRelativeOutputFolder(old.getApplicationRelativeOutputFolder());
        newOpts.setCleanBeforeCompile(old.isCleanBeforeCompile());
        newOpts.setCompileBeforeDeploy(old.isCompileBeforeDeploy());
        newOpts.setIgnoreDependencies(!old.isFollowDependencies());
        newOpts.setProjectAbsoluteOutputURL(old.getDeployOutputURL());
        newOpts.setProjectRelativeOutputFolder(old.getDeployOutputFolder());
        HashStructure hash = newOpts.getHashStructure();
        hash.putBoolean("forceJarRewrite", old.isForceJarRewrite());
        if (old.getDefaultDeployHeapSize() != null) {
            hash.putInt("defaultDeployHeapSize", old.getDefaultDeployHeapSize().intValue());
        }
        hash.putBoolean("autoGenerateMar", old.isAutoGenerateMar());
        hash.putBoolean("includeDataSources", old.isIncludeDataSources());
        hash.putBoolean("autoUpdateWebXmlEjbRefs", old.isAutoUpdateWebXmlEjbRefs());
        hash.putBoolean("compactJavaScript", old.isCompactJavaScript());
        ExtensionMigrator.AdjustedObject[] adjustedObjects = new ExtensionMigrator.AdjustedObject[]{new ExtensionMigrator.AdjustedObject("deploymentOptions", (Object)newOpts)};
        return adjustedObjects;
    }

    @Deprecated
    public static class DeprecatedDeploymentOptions {
        public static final String DATA_KEY = "deployment-options";
        private boolean _compactJavaScript;
        private boolean _compileBeforeDeploy;
        private boolean _cleanBeforeCompile;
        private boolean _followDependencies;
        private File _oc4jHome;
        private boolean _autoUpdateWebXmlEjbRefs;
        private String _appRelativeOutputFolder;
        private URL _appAbsoluteOutputURL;
        private String _deployOutputFolder;
        private URL _deployOutputURL;
        private boolean _forceJarRewrite;
        private Integer _defaultDeployHeapSize;
        private boolean _includeDataSources;
        private boolean _autoGenerateMar;
        private boolean _accessInternalOC4JClasses;

        public DeprecatedDeploymentOptions() {
            this.setFollowDependencies(true);
            this.setCompileBeforeDeploy(true);
            this.setCleanBeforeCompile(false);
            this.setAutoUpdateWebXmlEjbRefs(true);
            this.setApplicationRelativeOutputFolder("deploy");
            this.setDeployOutputFolder("deploy");
            this.setIncludeDataSources(true);
            this.setAutoGenerateMar(true);
            this.setAccessInternalOC4JClasses(false);
            this.setCompactJavaScript(false);
        }

        public boolean isCompactJavaScript() {
            return this._compactJavaScript;
        }

        public void setCompactJavaScript(boolean compactJavaScript) {
            if (this._compactJavaScript != compactJavaScript) {
                this._compactJavaScript = compactJavaScript;
            }
        }

        public boolean isCompileBeforeDeploy() {
            return this._compileBeforeDeploy;
        }

        public boolean isCleanBeforeCompile() {
            return this._cleanBeforeCompile;
        }

        public void setCompileBeforeDeploy(boolean compileBeforeDeploy) {
            if (this._compileBeforeDeploy != compileBeforeDeploy) {
                this._compileBeforeDeploy = compileBeforeDeploy;
            }
        }

        public void setCleanBeforeCompile(boolean clean) {
            if (clean != this._cleanBeforeCompile) {
                this._cleanBeforeCompile = clean;
            }
        }

        public boolean isFollowDependencies() {
            return this._followDependencies;
        }

        public void setFollowDependencies(boolean follow) {
            this._followDependencies = follow;
        }

        public File getOc4jHome() {
            return this._oc4jHome;
        }

        public void setOc4jHome(File oc4jHome) {
            if (ModelUtil.areDifferent((Object)this._oc4jHome, (Object)oc4jHome)) {
                this._oc4jHome = oc4jHome;
            }
        }

        public boolean isAutoUpdateWebXmlEjbRefs() {
            return this._autoUpdateWebXmlEjbRefs;
        }

        public void setAutoUpdateWebXmlEjbRefs(boolean autoUpdateWebXmlEjbRefs) {
            if (this._autoUpdateWebXmlEjbRefs != autoUpdateWebXmlEjbRefs) {
                this._autoUpdateWebXmlEjbRefs = autoUpdateWebXmlEjbRefs;
            }
        }

        public String getApplicationRelativeOutputFolder() {
            return this._appRelativeOutputFolder;
        }

        public void setApplicationRelativeOutputFolder(String appRelativeOutputFolder) {
            if (ModelUtil.areDifferent((Object)this._appRelativeOutputFolder, (Object)appRelativeOutputFolder)) {
                this._appRelativeOutputFolder = appRelativeOutputFolder;
                this._appAbsoluteOutputURL = null;
            }
        }

        public URL getApplicationAbsoluteOutputURL() {
            return this._appAbsoluteOutputURL;
        }

        public void setApplicationAbsoluteOutputURL(URL appAbsoluteOutputURL) {
            if (ModelUtil.areDifferent((Object)this._appAbsoluteOutputURL, (Object)appAbsoluteOutputURL)) {
                this._appAbsoluteOutputURL = appAbsoluteOutputURL;
                this._appRelativeOutputFolder = null;
            }
        }

        public String getDeployOutputFolder() {
            return this._deployOutputFolder;
        }

        public void setDeployOutputFolder(String deployOutputFolder) {
            if (ModelUtil.areDifferent((Object)this._deployOutputFolder, (Object)deployOutputFolder)) {
                this._deployOutputFolder = deployOutputFolder;
                this._deployOutputURL = null;
            }
        }

        public URL getDeployOutputURL() {
            return this._deployOutputURL;
        }

        public void setDeployOutputURL(URL deployOutputURL) {
            if (ModelUtil.areDifferent((Object)this._deployOutputURL, (Object)deployOutputURL)) {
                this._deployOutputURL = deployOutputURL;
                this._deployOutputFolder = null;
            }
        }

        public boolean isForceJarRewrite() {
            return this._forceJarRewrite;
        }

        public void setForceJarRewrite(boolean forceJarRewrite) {
            if (this._forceJarRewrite != forceJarRewrite) {
                this._forceJarRewrite = forceJarRewrite;
            }
        }

        public Integer getDefaultDeployHeapSize() {
            return this._defaultDeployHeapSize;
        }

        public void setDefaultDeployHeapSize(Integer defaultDeployHeapSize) {
            if (ModelUtil.areDifferent((Object)this._defaultDeployHeapSize, (Object)defaultDeployHeapSize)) {
                this._defaultDeployHeapSize = defaultDeployHeapSize;
            }
        }

        public boolean isIncludeDataSources() {
            return this._includeDataSources;
        }

        public void setIncludeDataSources(boolean includeDataSources) {
            if (this._includeDataSources != includeDataSources) {
                this._includeDataSources = includeDataSources;
            }
        }

        public boolean isAutoGenerateMar() {
            return this._autoGenerateMar;
        }

        public void setAutoGenerateMar(boolean autoGenerateMar) {
            if (this._autoGenerateMar != autoGenerateMar) {
                this._autoGenerateMar = autoGenerateMar;
            }
        }

        public boolean isAccessInternalOC4JClasses() {
            return this._accessInternalOC4JClasses;
        }

        public void setAccessInternalOC4JClasses(boolean accessInternalOC4JClasses) {
            if (this._accessInternalOC4JClasses != accessInternalOC4JClasses) {
                this._accessInternalOC4JClasses = accessInternalOC4JClasses;
            }
        }
    }
}

