/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.tk.spi;

import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBBuilder;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBContext;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBRecognizer;
import oracle.jdeveloper.deploy.tk.Toolkit;
import oracle.jdeveloper.deploy.tk.ToolkitBuildException;
import oracle.jdeveloper.deploy.tk.spi.AbstractToolkitBuilder;
import oracle.jdeveloper.deploy.tk.spi.SpiToolkitRegistry;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;
import oracle.jdeveloper.deploy.tk.spi.ToolkitProvider;

public abstract class AbstractToolkitProvider
implements OBRecognizer<Element, Toolkit, Context>,
ToolkitProvider {
    protected final Class<? extends Toolkit> tkClass_;

    public AbstractToolkitProvider(Class<? extends Toolkit> tkClass) {
        assert (tkClass != null);
        this.tkClass_ = tkClass;
    }

    public Class<? extends Toolkit> getToolkitClass() {
        return this.tkClass_;
    }

    @Override
    public final OBBuilder<Element, Toolkit, Context> recognize(Element element, OBContext<Element, Toolkit, Context> context, Class classOrIntf) {
        if (!classOrIntf.isAssignableFrom(this.tkClass_)) {
            return null;
        }
        return this.create((ToolkitContext)((Object)context));
    }

    @Override
    public AbstractToolkitBuilder create(ToolkitContext tkContext) {
        Element element = tkContext.getElement();
        Class classOrIntf = tkContext.getToolkitClass();
        return this.create(element, tkContext, classOrIntf);
    }

    @Deprecated
    protected AbstractToolkitBuilder create(Element element, ToolkitContext tkContext, Class classOrIntf) {
        return null;
    }

    protected Toolkit buildDelegate(ToolkitContext tkContext) throws ToolkitBuildException {
        SpiToolkitRegistry reg = tkContext.getSpiToolkitRegistry();
        AbstractToolkitBuilder[] builders = reg.createBuilder(tkContext.getElement(), this.getToolkitClass());
        return reg.narrow(builders)[0].getToolkit();
    }
}

