/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.shell;

import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeploymentOptions;
import oracle.jdeveloper.deploy.Profile;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.shell.ShellConstants;
import oracle.jdeveloper.deploy.spi.ProgressObject;

public class ShellAdapter
implements ShellConstants {
    protected final DeployShell shell_;
    protected final Context context_;
    protected final Object lock_;

    public ShellAdapter(DeployShell shell) {
        this.shell_ = shell;
        this.context_ = this.shell_.getContext();
        assert (this.context_ != null);
        this.lock_ = this.shell_;
    }

    public ShellAdapter(Context context) {
        this.shell_ = null;
        this.context_ = context;
        this.lock_ = this.context_;
    }

    public DeployShell getShell() {
        return this.shell_;
    }

    public ProgressObject getDeploymentProgressObject() {
        return (ProgressObject)this.getRoot().get("Deployment.runnableObject");
    }

    public static ShellAdapter getInstance(DeployShell shell) {
        return new ShellAdapter(shell);
    }

    public static ShellAdapter getInstance(Context context) {
        return new ShellAdapter(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object find(String key) {
        Object o = null;
        Object object = this.lock_;
        synchronized (object) {
            if (this.shell_ != null) {
                o = this.shell_.find(key);
            }
            if (o == null) {
                o = this.context_.getProperty(key);
            }
        }
        return o;
    }

    public Boolean findFlag(String key, boolean def) {
        Object o = this.find(key);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Object o = null;
        Object object = this.lock_;
        synchronized (object) {
            if (this.shell_ != null) {
                o = this.shell_.get(key);
            }
            if (o == null) {
                o = this.context_.getProperty(key);
            }
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, Object value) {
        Object object = this.lock_;
        synchronized (object) {
            if (this.shell_ != null) {
                this.shell_.put(key, value);
                return;
            }
            this.context_.setProperty(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(String key) {
        Object object = this.lock_;
        synchronized (object) {
            if (this.shell_ != null) {
                return this.shell_.remove(key);
            }
            Object value = this.context_.getProperty(key);
            this.context_.removeProperty(key);
            return value;
        }
    }

    public ShellAdapter getRoot() {
        return ShellAdapter.getInstance(this.shell_.getRoot());
    }

    public ShellAdapter newChildShell() {
        return this.newAdapter(new DeployShell(this.shell_));
    }

    public ShellAdapter newChildShell(Context context) {
        DeployShell shell = new DeployShell(this.shell_);
        shell.setContext(context);
        return this.newAdapter(shell);
    }

    protected ShellAdapter newAdapter(DeployShell shell) {
        return ShellAdapter.getInstance(shell);
    }

    public Context getContext() {
        return this.context_;
    }

    public Element getDeployElement() {
        Element e = (Element)this.find(KEY_DEPLOY_ELEMENT);
        if (e == null) {
            e = this.getContext().getElement();
        }
        return e;
    }

    public void setDeployElement(Element element) {
        this.put(KEY_DEPLOY_ELEMENT, element);
    }

    public boolean isProfileBasedDeployment() {
        return this.getDeployElement() instanceof Profile;
    }

    public void setLogger(Logger logger) {
        this.shell_.setLogger(logger);
    }

    public Logger getLogger() {
        return this.shell_.getLogger();
    }

    public Platform getPlatform() {
        return (Platform)this.find(KEY_PLATFORM);
    }

    public void setPlatform(Platform platform) {
        this.put(KEY_PLATFORM, platform);
    }

    public Profile getProfile() {
        if (this.isProfileBasedDeployment()) {
            return (Profile)this.getDeployElement();
        }
        return null;
    }

    public void setProfile(Profile p) {
        this.setDeployElement(p);
    }

    public DeployException getDeployException() {
        return this.shell_.getDeployException();
    }

    public void setDeployException(DeployException e) {
        this.shell_.setDeployException(e);
    }

    public boolean isDeploying(int sequence) {
        return this.shell_.isDeploying(sequence);
    }

    public boolean isDeploying(int[] sequences) {
        return this.shell_.isDeploying(sequences);
    }

    public boolean isHeadlessDeployment() {
        return this.findFlag("Deployment.flag.isHeadless", !Ide.getIdeArgs().getCreateUI());
    }

    public void setPrintTimeMessages(boolean value) {
        this.put("Deployment.printTimeMessages", value);
    }

    public boolean getPrintTimeMessages() {
        return this.findFlag("Deployment.printTimeMessages", Boolean.TRUE);
    }

    public boolean isSuppressDeploymentStartFinishMessage() {
        return this.findFlag("Deployment.suppressDeploymentStartFinishMessage", Boolean.FALSE);
    }

    public void setSuppressDeploymentStartFinishMessage(boolean value) {
        this.put("Deployment.suppressDeploymentStartFinishMessage", value);
    }

    public void setStatefulDeployment(boolean stateful) {
        this.put("Deployment.stateful", stateful);
    }

    public boolean isStatefulDeployment() {
        return this.findFlag("Deployment.stateful", false);
    }

    public void setDeploymentOptions(DeploymentOptions options) {
        this.put("Deployment.deploymentOptions", options.getHashStructure().copyTo(null));
    }

    public void setDeploymentOptions(HashStructure hash) {
        this.put("Deployment.deploymentOptions", hash.copyTo(null));
    }

    public <T extends DeploymentOptions> T getDeploymentOptions(Class<T> optionsClass) {
        return DeploymentOptions.create(this.getDeploymentOptionsHash(), optionsClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends DeploymentOptions> T getOrCreateDeploymentOptions(Class<T> optionsClass) {
        Object object = this.lock_;
        synchronized (object) {
            HashStructure hash = this.getDeploymentOptionsHash();
            if (hash == null) {
                this.setDeploymentOptions(DeploymentOptions.getDefault(DeploymentOptions.class));
            }
            assert (this.getDeploymentOptionsHash() != null);
            return DeploymentOptions.create(this.getDeploymentOptionsHash(), optionsClass);
        }
    }

    public DeploymentOptions getDeploymentOptions() {
        return this.getDeploymentOptions(DeploymentOptions.class);
    }

    public DeploymentOptions getOrCreateDeploymentOptions() {
        return this.getOrCreateDeploymentOptions(DeploymentOptions.class);
    }

    public HashStructure getDeploymentOptionsHash() {
        return (HashStructure)this.find("Deployment.deploymentOptions");
    }
}

