/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.jar;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.Archive;
import oracle.jdeveloper.deploy.DefaultLinkedDirtyable;
import oracle.jdeveloper.deploy.res.JarBundle;

public class ArchiveOptions
extends DefaultLinkedDirtyable
implements Copyable {
    private final HashStructure _hash;
    private static String KEY_COMPRESSED = "compressed";
    private static String KEY_COMPRESSION_LEVEL = "compressionLevel";
    private static String KEY_HAS_MANIFEST = "hasManifest";
    private static String KEY_MAIN_CLASS = "mainClass";
    private static String KEY_ADDITIONAL_MANIFESTS = "additionalManifests";

    public ArchiveOptions() {
        this(HashStructure.newInstance());
        this.setHasManifest(true);
    }

    public ArchiveOptions(HashStructure hash) {
        this._hash = hash;
    }

    public Object copyTo(Object target) {
        ArchiveOptions copy = target != null ? (ArchiveOptions)target : new ArchiveOptions(HashStructure.newInstance());
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(ArchiveOptions copy) {
        this._hash.copyTo(copy._hash);
    }

    public boolean isCompressed() {
        return this._hash.getBoolean(KEY_COMPRESSED);
    }

    public void setCompressed(boolean compressed) {
        if (this.isCompressed() != compressed) {
            this._hash.putBoolean(KEY_COMPRESSED, compressed);
            this.markDirty(true);
        }
    }

    public int getCompressionLevel() {
        if (this._hash.containsKey(KEY_COMPRESSION_LEVEL)) {
            return this._hash.getInt(KEY_COMPRESSION_LEVEL);
        }
        return -1;
    }

    public void setCompressionLevel(int level) {
        if (level != this.getCompressionLevel()) {
            assert (level >= -1 && level <= 9);
            this._hash.putInt(KEY_COMPRESSION_LEVEL, level);
        }
    }

    public boolean getHasManifest() {
        return this._hash.getBoolean(KEY_HAS_MANIFEST);
    }

    public void setHasManifest(boolean hasManifest) {
        if (this.getHasManifest() != hasManifest) {
            this._hash.putBoolean(KEY_HAS_MANIFEST, hasManifest);
            this.markDirty(true);
        }
    }

    public String getMainClass() {
        return this._hash.getString(KEY_MAIN_CLASS);
    }

    public void setMainClass(String mainClass) {
        if (ModelUtil.areDifferent((Object)this.getMainClass(), (Object)mainClass)) {
            this._hash.putString(KEY_MAIN_CLASS, mainClass);
            this.markDirty(true);
        }
    }

    public URL[] getAdditionalManifests() {
        ListStructure list = this._hash.getListStructure(KEY_ADDITIONAL_MANIFESTS);
        if (list == null) {
            return null;
        }
        return (URL[])list.toArray((Object[])new URL[list.size()]);
    }

    public void setAdditionalManifests(URL[] additionalManifests) {
        if (!Arrays.equals(this.getAdditionalManifests(), additionalManifests)) {
            ListStructure list = this._hash.getOrCreateListStructure(KEY_ADDITIONAL_MANIFESTS);
            list.clear();
            if (additionalManifests != null) {
                list.addAll(Arrays.asList(additionalManifests));
            }
            this.markDirty(true);
        }
    }

    public void applyOptionsTo(Archive archive) throws IOException {
        if (archive != null) {
            archive.setCompressed(this.isCompressed());
            archive.setCompressionLevel(this.getCompressionLevel());
            boolean includeManifest = this.getHasManifest();
            archive.setIncludeManifest(includeManifest);
            if (includeManifest) {
                String mainClass;
                URL[] moreManifests = this.getAdditionalManifests();
                if (moreManifests != null) {
                    for (URL url : moreManifests) {
                        try {
                            archive.mergeManifest(url);
                        }
                        catch (IOException e) {
                            String msg = JarBundle.format("AO_ERROR_MERGING_MANIFEST", url.getPath(), e.getMessage());
                            throw new IOException(msg);
                        }
                    }
                }
                if (ModelUtil.hasLength((String)(mainClass = this.getMainClass()))) {
                    archive.setMainClass(mainClass);
                }
            }
        }
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((ArchiveOptions)o);
    }

    protected final boolean equalsImpl(ArchiveOptions opts) {
        return this._hash.equals((Object)opts._hash);
    }
}

